/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.block.AbstractFixedWidthBlock;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.FixedWidthBlock;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.util.Arrays;

public class FixedWidthBlockBuilder
extends AbstractFixedWidthBlock
implements BlockBuilder {
    private final BlockBuilderStatus blockBuilderStatus;
    private final SliceOutput sliceOutput;
    private boolean[] valueIsNull;
    private int positionCount;
    private int currentEntrySize;

    public FixedWidthBlockBuilder(int fixedSize, BlockBuilderStatus blockBuilderStatus) {
        super(fixedSize);
        this.blockBuilderStatus = blockBuilderStatus;
        this.sliceOutput = new DynamicSliceOutput(blockBuilderStatus.getMaxBlockSizeInBytes());
        this.valueIsNull = new boolean[1024];
    }

    public FixedWidthBlockBuilder(int fixedSize, int positionCount) {
        super(fixedSize);
        Slice slice = Slices.allocate((int)(fixedSize * positionCount));
        this.blockBuilderStatus = new BlockBuilderStatus(slice.length(), slice.length());
        this.sliceOutput = slice.getOutput();
        this.valueIsNull = new boolean[positionCount];
    }

    @Override
    protected Slice getRawSlice() {
        return this.sliceOutput.getUnderlyingSlice();
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public boolean isEmpty() {
        return this.positionCount == 0;
    }

    @Override
    public boolean isFull() {
        return this.blockBuilderStatus.isFull();
    }

    @Override
    public int getSizeInBytes() {
        long size = (long)this.getRawSlice().length() + SizeOf.sizeOf((boolean[])this.valueIsNull);
        if (size > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)size;
    }

    @Override
    public BlockBuilder writeByte(int value) {
        this.sliceOutput.writeByte(value);
        ++this.currentEntrySize;
        return this;
    }

    @Override
    public BlockBuilder writeShort(int value) {
        this.sliceOutput.writeShort(value);
        this.currentEntrySize += 2;
        return this;
    }

    @Override
    public BlockBuilder writeInt(int value) {
        this.sliceOutput.writeInt(value);
        this.currentEntrySize += 4;
        return this;
    }

    @Override
    public BlockBuilder writeLong(long value) {
        this.sliceOutput.writeLong(value);
        this.currentEntrySize += 8;
        return this;
    }

    @Override
    public BlockBuilder writeFloat(float value) {
        this.sliceOutput.writeFloat(value);
        this.currentEntrySize += 4;
        return this;
    }

    @Override
    public BlockBuilder writeDouble(double value) {
        this.sliceOutput.writeDouble(value);
        this.currentEntrySize += 8;
        return this;
    }

    @Override
    public BlockBuilder writeBytes(Slice source, int sourceIndex, int length) {
        this.sliceOutput.writeBytes(source, sourceIndex, length);
        this.currentEntrySize += length;
        return this;
    }

    @Override
    public BlockBuilder closeEntry() {
        if (this.currentEntrySize != this.fixedSize) {
            throw new IllegalStateException("Expected entry size to be exactly " + this.fixedSize + " but was " + this.currentEntrySize);
        }
        this.entryAdded(false);
        this.currentEntrySize = 0;
        return this;
    }

    @Override
    public BlockBuilder appendNull() {
        if (this.currentEntrySize > 0) {
            throw new IllegalStateException("Current entry must be closed before a null can be written");
        }
        this.sliceOutput.writeZero(this.fixedSize);
        this.entryAdded(true);
        return this;
    }

    private void entryAdded(boolean isNull) {
        if (this.positionCount == this.valueIsNull.length - 1) {
            this.valueIsNull = Arrays.copyOf(this.valueIsNull, this.valueIsNull.length * 2);
        }
        this.valueIsNull[this.positionCount] = isNull;
        ++this.positionCount;
        this.blockBuilderStatus.addBytes(this.fixedSize);
        if (this.sliceOutput.size() >= this.blockBuilderStatus.getMaxBlockSizeInBytes()) {
            this.blockBuilderStatus.setFull();
        }
    }

    @Override
    protected boolean isEntryNull(int position) {
        return this.valueIsNull[position];
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        int positionCount = this.getPositionCount();
        if (positionOffset < 0 || length < 0 || positionOffset + length > positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + positionOffset + " in block with " + positionCount + " positions");
        }
        Slice newSlice = this.sliceOutput.slice().slice(positionOffset * this.fixedSize, length * this.fixedSize);
        boolean[] newValueIsNull = Arrays.copyOfRange(this.valueIsNull, positionOffset, positionOffset + length);
        return new FixedWidthBlock(this.fixedSize, length, newSlice, newValueIsNull);
    }

    @Override
    public Block build() {
        if (this.currentEntrySize > 0) {
            throw new IllegalStateException("Current entry must be closed before the block can be built");
        }
        return new FixedWidthBlock(this.fixedSize, this.positionCount, this.sliceOutput.slice(), this.valueIsNull);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FixedWidthBlockBuilder{");
        sb.append("positionCount=").append(this.positionCount);
        sb.append(", fixedSize=").append(this.fixedSize);
        sb.append(", size=").append(this.sliceOutput.size());
        sb.append('}');
        return sb.toString();
    }
}

