/*
 * Decompiled with CFR 0.152.
 */
package lombok.eclipse.handlers;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.Statement;
import lombok.core.handlers.IParameterValidator;
import lombok.core.util.Each;
import lombok.eclipse.EclipseNode;
import lombok.eclipse.handlers.Eclipse;
import lombok.eclipse.handlers.EclipseHandlerUtil;
import lombok.eclipse.handlers.ast.EclipseMethod;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;

public class EclipseParameterValidator
implements IParameterValidator<EclipseMethod> {
    @Override
    public List<Statement<?>> validateParameterOf(EclipseMethod method) {
        ArrayList validateStatements = new ArrayList();
        int argumentIndex = 0;
        block0: for (Argument argument : Each.elementIn(method.get().arguments)) {
            String argumentName = new String(argument.name);
            ++argumentIndex;
            for (IParameterValidator.ValidationStrategy validationStrategy : IParameterValidator.ValidationStrategy.IN_ORDER) {
                Annotation ann = Eclipse.getAnnotation(validationStrategy.getType(), argument.annotations);
                if (ann == null || EclipseHandlerUtil.isGenerated((ASTNode)ann)) continue;
                EclipseNode annotationNode = (EclipseNode)method.node().getNodeFor(ann);
                java.lang.annotation.Annotation annotation = EclipseHandlerUtil.createAnnotation(validationStrategy.getType(), annotationNode).getInstance();
                validateStatements.addAll(validationStrategy.getStatementsFor(argumentName, argumentIndex, annotation));
                EclipseHandlerUtil.setGeneratedBy((ASTNode)ann, (ASTNode)ann);
                argument.bits |= 0x800000;
                continue block0;
            }
        }
        for (Statement statement : validateStatements) {
            statement.posHint(method.get());
        }
        return validateStatements;
    }
}

