/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers;

import com.sun.tools.javac.tree.JCTree;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import lombok.Sanitize;
import lombok.ast.Statement;
import lombok.core.handlers.IParameterSanitizer;
import lombok.core.util.Names;
import lombok.javac.JavacNode;
import lombok.javac.handlers.Javac;
import lombok.javac.handlers.JavacHandlerUtil;
import lombok.javac.handlers.ast.JavacMethod;

public class JavacParameterSanitizer
implements IParameterSanitizer<JavacMethod> {
    @Override
    public List<Statement<?>> sanitizeParameterOf(JavacMethod method) {
        Javac.deleteImport(method.node(), Sanitize.class);
        for (IParameterSanitizer.SanitizerStrategy sanitizerStrategy : IParameterSanitizer.SanitizerStrategy.IN_ORDER) {
            Javac.deleteImport(method.node(), sanitizerStrategy.getType());
        }
        ArrayList sanitizeStatements = new ArrayList();
        block1: for (JCTree.JCVariableDecl jCVariableDecl : method.get().params) {
            String argumentName = jCVariableDecl.name.toString();
            String newArgumentName = Names.camelCase("sanitized", argumentName);
            for (IParameterSanitizer.SanitizerStrategy sanitizerStrategy : IParameterSanitizer.SanitizerStrategy.IN_ORDER) {
                JCTree.JCAnnotation ann = Javac.getAnnotation(sanitizerStrategy.getType(), jCVariableDecl.mods);
                if (ann == null) continue;
                JavacNode annotationNode = (JavacNode)method.node().getNodeFor(ann);
                Annotation annotation = JavacHandlerUtil.createAnnotation(sanitizerStrategy.getType(), annotationNode).getInstance();
                sanitizeStatements.add(sanitizerStrategy.getStatementFor(jCVariableDecl.vartype, argumentName, newArgumentName, annotation));
                method.editor().replaceVariableName(argumentName, newArgumentName);
                jCVariableDecl.mods.flags |= 0x10L;
                jCVariableDecl.mods.annotations = Javac.remove(jCVariableDecl.mods.annotations, ann);
                continue block1;
            }
        }
        for (Statement statement : sanitizeStatements) {
            statement.posHint(method.get());
        }
        return sanitizeStatements;
    }
}

