/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers.ast;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import java.util.ArrayList;
import java.util.List;
import lombok.ast.AST;
import lombok.ast.Annotation;
import lombok.ast.IType;
import lombok.ast.TypeParam;
import lombok.ast.TypeRef;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.core.LombokNode;
import lombok.core.util.As;
import lombok.core.util.Cast;
import lombok.javac.JavacNode;
import lombok.javac.handlers.Javac;
import lombok.javac.handlers.JavacHandlerUtil;
import lombok.javac.handlers.ast.JavacField;
import lombok.javac.handlers.ast.JavacMethod;
import lombok.javac.handlers.ast.JavacTypeEditor;

public final class JavacType
implements IType<JavacMethod, JavacField, JavacNode, JCTree, JCTree.JCClassDecl, JCTree.JCMethodDecl> {
    private final JavacNode typeNode;
    private final JCTree source;
    private final JavacTypeEditor editor;

    private JavacType(JavacNode typeNode, JCTree source) {
        if (!(typeNode.get() instanceof JCTree.JCClassDecl)) {
            throw new IllegalArgumentException();
        }
        this.typeNode = typeNode;
        this.source = source;
        this.editor = new JavacTypeEditor(this, source);
    }

    public JavacTypeEditor editor() {
        return this.editor;
    }

    @Override
    public boolean isInterface() {
        return (this.get().mods.flags & 0x200L) != 0L;
    }

    @Override
    public boolean isEnum() {
        return (this.get().mods.flags & 0x4000L) != 0L;
    }

    @Override
    public boolean isAnnotation() {
        return (this.get().mods.flags & 0x2000L) != 0L;
    }

    @Override
    public boolean isClass() {
        return !this.isInterface() && !this.isEnum() && !this.isAnnotation();
    }

    @Override
    public boolean hasSuperClass() {
        return this.get().getExtendsClause() != null;
    }

    @Override
    public <A extends java.lang.annotation.Annotation> AnnotationValues<A> getAnnotationValue(Class<A> expectedType) {
        LombokNode node = this.getAnnotation(expectedType);
        return node == null ? null : JavacHandlerUtil.createAnnotation(expectedType, (JavacNode)node);
    }

    @Override
    public JavacNode getAnnotation(Class<? extends java.lang.annotation.Annotation> expectedType) {
        return this.getAnnotation(expectedType.getName());
    }

    @Override
    public JavacNode getAnnotation(String typeName) {
        JavacNode annotationNode = null;
        for (JavacNode child : this.node().down()) {
            if (child.getKind() != AST.Kind.ANNOTATION || !Javac.matchesType((JCTree.JCAnnotation)child.get(), typeName)) continue;
            annotationNode = child;
        }
        return annotationNode;
    }

    @Override
    public <T extends IType<?, ?, ?, ?, ?, ?>> T memberType(String typeName) {
        for (JavacNode child : this.node().down()) {
            if (child.getKind() != AST.Kind.TYPE || !child.getName().equals(typeName)) continue;
            return (T)((IType)Cast.uncheckedCast(JavacType.typeOf(child, this.source)));
        }
        throw new IllegalArgumentException();
    }

    @Override
    public <T extends IType<?, ?, ?, ?, ?, ?>> T surroundingType() {
        JavacNode parent = (JavacNode)this.node().directUp();
        if (parent == null) {
            return null;
        }
        return (T)((IType)Cast.uncheckedCast(JavacType.typeOf(parent, this.source)));
    }

    @Override
    public List<JavacMethod> methods() {
        ArrayList<JavacMethod> methods = new ArrayList<JavacMethod>();
        for (JavacNode child : this.node().down()) {
            if (child.getKind() != AST.Kind.METHOD) continue;
            methods.add(JavacMethod.methodOf(child, this.source));
        }
        return methods;
    }

    @Override
    public List<JavacField> fields() {
        ArrayList<JavacField> fields = new ArrayList<JavacField>();
        for (JavacNode child : this.node().down()) {
            if (child.getKind() != AST.Kind.FIELD) continue;
            fields.add(JavacField.fieldOf(child, this.source));
        }
        return fields;
    }

    @Override
    public boolean hasMultiArgumentConstructor() {
        for (JCTree def : this.get().defs) {
            if (!(def instanceof JCTree.JCMethodDecl) || ((JCTree.JCMethodDecl)def).params.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public JCTree.JCClassDecl get() {
        return (JCTree.JCClassDecl)this.typeNode.get();
    }

    @Override
    public JavacNode node() {
        return this.typeNode;
    }

    @Override
    public String name() {
        return this.node().getName();
    }

    @Override
    public List<TypeRef> typeArguments() {
        ArrayList<TypeRef> typeArguments = new ArrayList<TypeRef>();
        for (JCTree.JCTypeParameter typaram : this.get().typarams) {
            typeArguments.add(AST.Type(As.string(typaram.name)));
        }
        return typeArguments;
    }

    @Override
    public List<TypeParam> typeParameters() {
        ArrayList<TypeParam> typeParameters = new ArrayList<TypeParam>();
        for (JCTree.JCTypeParameter typaram : this.get().typarams) {
            TypeParam typeParam = AST.TypeParam(As.string(typaram.name));
            for (JCTree.JCExpression expr : typaram.bounds) {
                typeParam.withBound(AST.Type(expr));
            }
            typeParameters.add(typeParam);
        }
        return typeParameters;
    }

    @Override
    public List<Annotation> annotations() {
        return this.annotations(this.get().mods);
    }

    private List<Annotation> annotations(JCTree.JCModifiers mods) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (JCTree.JCAnnotation annotation : mods.annotations) {
            Annotation ann = AST.Annotation(AST.Type(annotation.annotationType));
            for (JCTree.JCExpression arg : annotation.args) {
                if (arg instanceof JCTree.JCAssign) {
                    JCTree.JCAssign assign = (JCTree.JCAssign)arg;
                    ann.withValue(assign.lhs.toString(), AST.Expr(assign.rhs));
                    continue;
                }
                ann.withValue(AST.Expr(arg));
            }
            annotations.add(ann);
        }
        return annotations;
    }

    @Override
    public boolean hasField(String fieldName) {
        return JavacHandlerUtil.fieldExists(fieldName, this.typeNode) != JavacHandlerUtil.MemberExistsResult.NOT_EXISTS;
    }

    @Override
    public boolean hasMethod(String methodName, TypeRef ... argumentTypes) {
        return JavacHandlerUtil.methodExists(methodName, this.typeNode, false, argumentTypes == null ? 0 : argumentTypes.length) != JavacHandlerUtil.MemberExistsResult.NOT_EXISTS;
    }

    @Override
    public boolean hasMethodIncludingSupertypes(String methodName, TypeRef ... argumentTypes) {
        return this.hasMethod(this.get().sym, methodName, this.editor().build(As.list(argumentTypes)));
    }

    private boolean hasMethod(Symbol.TypeSymbol type, String methodName, List<JCTree> argumentTypes) {
        if (type == null) {
            return false;
        }
        for (Symbol enclosedElement : type.getEnclosedElements()) {
            if (!(enclosedElement instanceof Symbol.MethodSymbol) || (enclosedElement.flags() & 0x400L) != 0L || (enclosedElement.flags() & 1L) == 0L) continue;
            Symbol.MethodSymbol method = (Symbol.MethodSymbol)enclosedElement;
            if (!methodName.equals(As.string(method.name))) continue;
            Type.MethodType methodType = (Type.MethodType)method.type;
            if (argumentTypes.size() != methodType.argtypes.size()) continue;
            return true;
        }
        Type supertype = ((Symbol.ClassSymbol)type).getSuperclass();
        return this.hasMethod(supertype.tsym, methodName, argumentTypes);
    }

    public String toString() {
        return this.get().toString();
    }

    public static JavacType typeOf(JavacNode node, JCTree source) {
        JavacNode typeNode = Javac.typeNodeOf(node);
        return typeNode == null ? null : new JavacType(typeNode, source);
    }
}

