/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.node;

import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.extension.NamedArguments;
import com.mitchellbosecke.pebble.extension.NodeVisitor;
import com.mitchellbosecke.pebble.node.NamedArgumentNode;
import com.mitchellbosecke.pebble.node.Node;
import com.mitchellbosecke.pebble.node.PositionalArgumentNode;
import com.mitchellbosecke.pebble.template.EvaluationContext;
import com.mitchellbosecke.pebble.template.PebbleTemplateImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ArgumentsNode
implements Node {
    private final List<NamedArgumentNode> namedArgs;
    private List<PositionalArgumentNode> positionalArgs;

    public ArgumentsNode(List<PositionalArgumentNode> positionalArgs, List<NamedArgumentNode> namedArgs) {
        this.positionalArgs = positionalArgs;
        this.namedArgs = namedArgs;
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    public List<NamedArgumentNode> getNamedArgs() {
        return this.namedArgs;
    }

    public List<PositionalArgumentNode> getPositionalArgs() {
        return this.positionalArgs;
    }

    public Map<String, Object> getArgumentMap(PebbleTemplateImpl self, EvaluationContext context, NamedArguments invocableWithNamedArguments) throws PebbleException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<String> argumentNames = invocableWithNamedArguments.getArgumentNames();
        if (argumentNames == null) {
            if (this.positionalArgs != null && !this.positionalArgs.isEmpty()) {
                for (int i = 0; i < this.positionalArgs.size(); ++i) {
                    result.put(String.valueOf(i), this.positionalArgs.get(i).getValueExpression().evaluate(self, context));
                }
            }
        } else {
            if (this.positionalArgs != null) {
                int nameIndex = 0;
                for (PositionalArgumentNode arg : this.positionalArgs) {
                    result.put(argumentNames.get(nameIndex), arg.getValueExpression().evaluate(self, context));
                    ++nameIndex;
                }
            }
            if (this.namedArgs != null) {
                for (NamedArgumentNode arg : this.namedArgs) {
                    if (!argumentNames.contains(arg.getName())) {
                        throw new PebbleException(null, "The following named argument does not exist: " + arg.getName());
                    }
                    Object value = arg.getValueExpression() == null ? null : (Object)arg.getValueExpression().evaluate(self, context);
                    result.put(arg.getName(), value);
                }
            }
        }
        result.put("_self", self);
        result.put("_context", context);
        return result;
    }
}

