/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.body;

import com.fasterxml.jackson.core.type.TypeReference;
import com.networknt.body.BodyConfig;
import com.networknt.config.Config;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.status.Status;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import io.undertow.util.Headers;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BodyHandler
implements MiddlewareHandler {
    static final Logger logger = LoggerFactory.getLogger(BodyHandler.class);
    static final String CONTENT_TYPE_MISMATCH = "ERR10015";
    public static final AttachmentKey<Object> REQUEST_BODY = AttachmentKey.create(Object.class);
    public static final String CONFIG_NAME = "body";
    public static final BodyConfig config = (BodyConfig)Config.getInstance().getJsonObjectConfig("body", BodyConfig.class);
    private volatile HttpHandler next;

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String contentType = exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
        if (contentType != null && contentType.startsWith("application/json")) {
            if (exchange.isInIoThread()) {
                exchange.dispatch((HttpHandler)this);
                return;
            }
            exchange.startBlocking();
            InputStream is = exchange.getInputStream();
            if (is != null) {
                try {
                    if (is.available() != -1) {
                        Object body;
                        String s = new Scanner(is, "UTF-8").useDelimiter("\\A").next();
                        if ((s = s.trim()).startsWith("{")) {
                            body = Config.getInstance().getMapper().readValue(s, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
                        } else if (s.startsWith("[")) {
                            body = Config.getInstance().getMapper().readValue(s, (TypeReference)new TypeReference<List<HashMap<String, Object>>>(){});
                        } else {
                            Status status = new Status(CONTENT_TYPE_MISMATCH, new Object[]{contentType});
                            exchange.setStatusCode(status.getStatusCode());
                            exchange.getResponseSender().send(status.toString());
                            return;
                        }
                        exchange.putAttachment(REQUEST_BODY, body);
                    }
                }
                catch (IOException e) {
                    logger.error("IOException: ", (Throwable)e);
                }
            }
        }
        this.next.handleRequest(exchange);
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull((HttpHandler)next);
        this.next = next;
        return this;
    }

    public boolean isEnabled() {
        return config.isEnabled();
    }

    public void register() {
        ModuleRegistry.registerModule((String)BodyHandler.class.getName(), (Map)Config.getInstance().getJsonMapConfigNoCache(CONFIG_NAME), null);
    }
}

