/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.db;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.object.db.ODatabasePojoAbstract;
import com.orientechnologies.orient.object.enhancement.OObjectEntitySerializer;
import com.orientechnologies.orient.object.enhancement.OObjectProxyMethodHandler;
import java.io.Serializable;
import java.util.Iterator;
import javassist.util.proxy.ProxyObject;

public class OObjectLazyIterator<TYPE>
implements Iterator<TYPE>,
Serializable {
    private static final long serialVersionUID = -4012483076050044405L;
    private final ProxyObject sourceRecord;
    private final ODatabasePojoAbstract<TYPE> database;
    private final Iterator<? extends Object> underlying;
    private String fetchPlan;
    private final boolean autoConvert2Object;
    private OIdentifiable currentElement;
    private boolean orphanRemoval = false;

    public OObjectLazyIterator(ODatabasePojoAbstract<TYPE> database, ProxyObject iSourceRecord, Iterator<? extends Object> iIterator, boolean iConvertToRecord, boolean iOrphanRemoval) {
        this.database = database;
        this.sourceRecord = iSourceRecord;
        this.underlying = iIterator;
        this.autoConvert2Object = iConvertToRecord;
        this.orphanRemoval = iOrphanRemoval;
    }

    @Override
    public TYPE next() {
        return this.next(this.fetchPlan);
    }

    public TYPE next(String iFetchPlan) {
        Object value = this.underlying.next();
        if (value == null) {
            return null;
        }
        if (value instanceof ORID && this.autoConvert2Object) {
            this.currentElement = (OIdentifiable)value;
            ORecordInternal record = (ORecordInternal)((ODatabaseRecord)this.database.getUnderlying()).load((ORID)value, iFetchPlan);
            if (record == null) {
                OLogManager.instance().warn((Object)this, "Record " + ((OObjectProxyMethodHandler)this.sourceRecord.getHandler()).getDoc().getIdentity() + " references a deleted instance", new Object[0]);
                return null;
            }
            TYPE o = this.database.getUserObjectByRecord((OIdentifiable)record, iFetchPlan);
            ((OObjectProxyMethodHandler)((ProxyObject)o).getHandler()).setParentObject(this.sourceRecord);
            return o;
        }
        if (value instanceof ODocument && this.autoConvert2Object) {
            this.currentElement = (OIdentifiable)value;
            TYPE o = this.database.getUserObjectByRecord((OIdentifiable)((ODocument)value), iFetchPlan);
            ((OObjectProxyMethodHandler)((ProxyObject)o).getHandler()).setParentObject(this.sourceRecord);
            return o;
        }
        this.currentElement = this.database.getRecordByUserObject(value, false);
        if (OObjectEntitySerializer.isToSerialize(value.getClass())) {
            return (TYPE)OObjectEntitySerializer.deserializeFieldValue(value.getClass(), value);
        }
        return (TYPE)value;
    }

    @Override
    public boolean hasNext() {
        return this.underlying.hasNext();
    }

    @Override
    public void remove() {
        this.underlying.remove();
        if (this.sourceRecord != null) {
            if (this.orphanRemoval) {
                ((OObjectProxyMethodHandler)this.sourceRecord.getHandler()).getOrphans().add(this.currentElement.getIdentity());
            }
            ((OObjectProxyMethodHandler)this.sourceRecord.getHandler()).setDirty();
        }
    }

    public String getFetchPlan() {
        return this.fetchPlan;
    }

    public void setFetchPlan(String fetchPlan) {
        this.fetchPlan = fetchPlan;
    }
}

