/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.enhancement;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.object.enhancement.OObjectEntitySerializer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javassist.util.proxy.MethodFilter;

public class OObjectMethodFilter
implements MethodFilter {
    public boolean isHandled(Method m) {
        String methodName = m.getName();
        String fieldName = this.getFieldName(m);
        if (fieldName == null) {
            return false;
        }
        try {
            if (!OObjectEntitySerializer.isClassField(m.getDeclaringClass(), fieldName)) {
                return false;
            }
            return this.isSetterMethod(methodName, m) || this.isGetterMethod(methodName, m);
        }
        catch (NoSuchFieldException nsfe) {
            OLogManager.instance().warn((Object)this, "Error handling the method %s in class %s", (Throwable)nsfe, new Object[]{m.getName(), m.getDeclaringClass().getName()});
            return false;
        }
        catch (SecurityException se) {
            OLogManager.instance().warn((Object)this, "", (Throwable)se, new Object[]{m.getName(), m.getDeclaringClass().getName()});
            return false;
        }
    }

    public String getFieldName(Method m) {
        String methodName = m.getName();
        Class<?> clz = m.getDeclaringClass();
        if (methodName.startsWith("get")) {
            return this.getFieldName(methodName, "get");
        }
        if (methodName.startsWith("set")) {
            return this.getFieldName(methodName, "set");
        }
        if (methodName.startsWith("is")) {
            return this.getFieldName(methodName, "is");
        }
        if (this.isScalaClass(clz)) {
            return this.getScalaFieldName(clz, methodName);
        }
        return null;
    }

    protected String getFieldName(String methodName, String prefix) {
        StringBuffer fieldName = new StringBuffer();
        fieldName.append(Character.toLowerCase(methodName.charAt(prefix.length())));
        fieldName.append(methodName.substring(prefix.length() + 1));
        return fieldName.toString();
    }

    public boolean isSetterMethod(String methodName, Method m) throws SecurityException, NoSuchFieldException {
        Class<?> clz = m.getDeclaringClass();
        if (!methodName.startsWith("set") || !this.checkIfFirstCharAfterPrefixIsUpperCase(methodName, "set") || this.isScalaClass(clz) && !methodName.endsWith("_$eq")) {
            return false;
        }
        if (m.getParameterTypes() != null && m.getParameterTypes().length != 1) {
            return false;
        }
        if (OObjectEntitySerializer.isTransientField(m.getDeclaringClass(), this.getFieldName(m))) {
            return false;
        }
        Class<?>[] parameters = m.getParameterTypes();
        Field f = OObjectEntitySerializer.getField(this.getFieldName(m), m.getDeclaringClass());
        if (!f.getType().isAssignableFrom(parameters[0])) {
            OLogManager.instance().warn((Object)this, "Setter method " + m.toString() + " for field " + f.getName() + " in class " + m.getDeclaringClass().toString() + " cannot be bound to proxied instance: parameter class don't match with field type " + f.getType().toString(), new Object[0]);
            return false;
        }
        return true;
    }

    public boolean isGetterMethod(String fieldName, Method m) throws SecurityException, NoSuchFieldException {
        int prefixLength;
        Class<?> clz = m.getDeclaringClass();
        if (fieldName.startsWith("get") && this.checkIfFirstCharAfterPrefixIsUpperCase(fieldName, "get")) {
            prefixLength = "get".length();
        } else if (fieldName.startsWith("is") && this.checkIfFirstCharAfterPrefixIsUpperCase(fieldName, "is")) {
            prefixLength = "is".length();
        } else if (this.isScalaClass(clz) && fieldName.equals(this.getFieldName(m))) {
            prefixLength = 0;
        } else {
            return false;
        }
        if (m.getParameterTypes() != null && m.getParameterTypes().length > 0) {
            return false;
        }
        if (fieldName.length() <= prefixLength) {
            return false;
        }
        return !OObjectEntitySerializer.isTransientField(m.getDeclaringClass(), this.getFieldName(m));
    }

    private boolean checkIfFirstCharAfterPrefixIsUpperCase(String methodName, String prefix) {
        return methodName.length() > prefix.length() ? Character.isUpperCase(methodName.charAt(prefix.length())) : false;
    }

    protected boolean isScalaClass(Class<?> clz) {
        Annotation[] annotations;
        for (Annotation a : annotations = clz.getDeclaredAnnotations()) {
            if (!"scala.reflect.ScalaSignature".contains(a.annotationType().getName()) && !"scala.reflect.ScalaLongSignature".contains(a.getClass().getName())) continue;
            return true;
        }
        return false;
    }

    protected String getScalaFieldName(Class<?> clz, String name) {
        Field[] fields;
        for (Field field : fields = clz.getDeclaredFields()) {
            if (name.equals(field.getName() + "_$eq")) {
                return field.getName();
            }
            if (!name.equals(field.getName())) continue;
            return field.getName();
        }
        return null;
    }
}

