/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.jpa.parsing;

import com.orientechnologies.orient.object.jpa.OJPAPersistenceUnitInfo;
import com.orientechnologies.orient.object.jpa.parsing.JPAVersion;
import com.orientechnologies.orient.object.jpa.parsing.PersistenceXml;
import com.orientechnologies.orient.object.jpa.parsing.PersistenceXmlUtil;
import java.net.URL;
import java.util.Collection;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class JPAHandler
extends DefaultHandler {
    private final Stack<OJPAPersistenceUnitInfo> persistenceUnits = new Stack();
    private final URL persistenceXmlRoot;
    private String xmlSchemaVersion;
    private PersistenceXml element;
    private StringBuilder builder = new StringBuilder();

    public JPAHandler(URL persistenceXmlRoot, JPAVersion jpaVersion) {
        this.persistenceXmlRoot = persistenceXmlRoot;
        this.xmlSchemaVersion = jpaVersion.getVersion();
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        this.element = PersistenceXml.parse(localName == null || localName.isEmpty() ? name : localName);
        switch (this.element) {
            case TAG_PERSISTENCE: {
                if (this.xmlSchemaVersion != null) break;
                this.xmlSchemaVersion = PersistenceXmlUtil.parseSchemaVersion(uri, this.element, attributes);
                break;
            }
            case TAG_PERSISTENCE_UNIT: {
                String unitName = attributes.getValue(PersistenceXml.ATTR_UNIT_NAME.toString());
                String transactionType = attributes.getValue(PersistenceXml.ATTR_TRANSACTION_TYPE.toString());
                this.persistenceUnits.push(new OJPAPersistenceUnitInfo(unitName, transactionType, this.persistenceXmlRoot, this.xmlSchemaVersion));
                break;
            }
            case TAG_EXCLUDE_UNLISTED_CLASSES: {
                this.persistenceUnits.peek().setExcludeUnlisted(true);
                break;
            }
            case TAG_PROPERTY: {
                this.persistenceUnits.peek().addProperty(attributes.getValue("name"), attributes.getValue("value"));
                break;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        String s = this.builder.toString().trim();
        this.builder = new StringBuilder();
        if (s.isEmpty()) {
            return;
        }
        OJPAPersistenceUnitInfo pu = this.persistenceUnits.peek();
        switch (this.element) {
            case TAG_PROVIDER: {
                pu.setProviderClassName(s);
                break;
            }
            case TAG_JTA_DATA_SOURCE: {
                pu.setJtaDataSource(s);
                break;
            }
            case TAG_NON_JTA_DATA_SOURCE: {
                pu.setNonJtaDataSource(s);
                break;
            }
            case TAG_MAPPING_FILE: {
                pu.addMappingFileName(s);
                break;
            }
            case TAG_JAR_FILE: {
                pu.addJarFileName(s);
                break;
            }
            case TAG_CLASS: {
                pu.addClassName(s);
                break;
            }
            case TAG_EXCLUDE_UNLISTED_CLASSES: {
                pu.setExcludeUnlisted(Boolean.parseBoolean(s));
                break;
            }
            case TAG_SHARED_CACHE_MODE: {
                pu.setSharedCacheMode(s);
                break;
            }
            case TAG_VALIDATION_MODE: {
                pu.setValidationMode(s);
                break;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.builder.append(ch, start, length);
    }

    @Override
    public void error(SAXParseException spe) throws SAXException {
        throw spe;
    }

    public Collection<OJPAPersistenceUnitInfo> getPersistenceUnits() {
        return this.persistenceUnits;
    }
}

