/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.jpa;

import com.orientechnologies.orient.object.jpa.OJPAProperties;
import com.orientechnologies.orient.object.jpa.parsing.JPAVersion;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.persistence.PersistenceException;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;

public class OJPAPersistenceUnitInfo
implements PersistenceUnitInfo {
    private final String unitName;
    private final PersistenceUnitTransactionType transactionType;
    private final URL unitRootUrl;
    private final List<String> mappingFileNames = new ArrayList<String>();
    private final List<String> managedClassNames = new ArrayList<String>();
    private boolean excludeUnlistedClasses = false;
    private SharedCacheMode sharedCacheMode = SharedCacheMode.UNSPECIFIED;
    private ValidationMode validationMode = ValidationMode.AUTO;
    private final Properties properties = new OJPAProperties();
    private final Set<ClassTransformer> classTransformers = new HashSet<ClassTransformer>();
    private final List<URL> jarFileUrls = new ArrayList<URL>();
    private String providerClassName;
    private final JPAVersion xmlSchemaVersion;

    public OJPAPersistenceUnitInfo(String unitName, String transactionType, URL unitRootUrl, String xmlSchemaVersion) {
        this.unitName = unitName;
        this.unitRootUrl = unitRootUrl;
        if (unitName == null || unitName.isEmpty()) {
            throw new IllegalStateException("PersistenceUnitName for entity manager should not be null or empty");
        }
        this.xmlSchemaVersion = JPAVersion.parse(xmlSchemaVersion);
        this.transactionType = OJPAPersistenceUnitInfo.initTransactionType(transactionType);
    }

    public void setProviderClassName(String providerClassName) {
        this.providerClassName = providerClassName;
    }

    public void setJtaDataSource(String jtaDataSource) {
    }

    public void setNonJtaDataSource(String nonJtaDataSource) {
    }

    public void addMappingFileName(String mappingFileName) {
        this.mappingFileNames.add(mappingFileName);
    }

    public void addJarFileName(String jarFileName) {
        this.jarFileUrls.add(OJPAPersistenceUnitInfo.initJarFile(jarFileName));
    }

    public void addClassName(String className) {
        this.managedClassNames.add(className);
    }

    public void setExcludeUnlisted(boolean exclude) {
        this.excludeUnlistedClasses = exclude;
    }

    public void addProperty(String name, String value) {
        this.properties.setProperty(name, value);
    }

    public void setSharedCacheMode(String sharedCacheMode) {
        this.sharedCacheMode = OJPAPersistenceUnitInfo.initSharedCacheMode(sharedCacheMode);
    }

    public void setValidationMode(String validationMode) {
        this.validationMode = OJPAPersistenceUnitInfo.initValidationMode(validationMode);
    }

    public String toString() {
        return "PersistenceUnit@" + this.unitName + " " + super.toString();
    }

    public String getPersistenceUnitName() {
        return this.unitName;
    }

    public String getPersistenceProviderClassName() {
        return this.providerClassName;
    }

    public PersistenceUnitTransactionType getTransactionType() {
        return this.transactionType;
    }

    public DataSource getJtaDataSource() {
        return null;
    }

    public DataSource getNonJtaDataSource() {
        return null;
    }

    public List<String> getMappingFileNames() {
        return this.mappingFileNames;
    }

    public List<URL> getJarFileUrls() {
        return this.jarFileUrls;
    }

    public URL getPersistenceUnitRootUrl() {
        return this.unitRootUrl;
    }

    public List<String> getManagedClassNames() {
        return this.managedClassNames;
    }

    public boolean excludeUnlistedClasses() {
        return this.excludeUnlistedClasses;
    }

    public SharedCacheMode getSharedCacheMode() {
        return this.sharedCacheMode;
    }

    public ValidationMode getValidationMode() {
        return this.validationMode;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getPersistenceXMLSchemaVersion() {
        return this.xmlSchemaVersion.getVersion();
    }

    public ClassLoader getClassLoader() {
        return ThreadLocal.class.getClassLoader();
    }

    public void addTransformer(ClassTransformer transformer) {
        this.classTransformers.add(transformer);
    }

    public ClassLoader getNewTempClassLoader() {
        return null;
    }

    public int hashCode() {
        return this.unitName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.unitName.equals(((OJPAPersistenceUnitInfo)obj).getPersistenceUnitName());
    }

    public static PersistenceUnitTransactionType initTransactionType(String elementContent) {
        if (elementContent == null || elementContent.isEmpty()) {
            return null;
        }
        try {
            return PersistenceUnitTransactionType.valueOf((String)elementContent.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            throw new PersistenceException("Unknown TransactionType: " + elementContent, (Throwable)ex);
        }
    }

    public static ValidationMode initValidationMode(String validationMode) {
        if (validationMode == null || validationMode.isEmpty()) {
            return ValidationMode.AUTO;
        }
        try {
            return ValidationMode.valueOf((String)validationMode.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            throw new PersistenceException("Unknown ValidationMode: " + validationMode, (Throwable)ex);
        }
    }

    public static SharedCacheMode initSharedCacheMode(String sharedCacheMode) {
        if (sharedCacheMode == null || sharedCacheMode.isEmpty()) {
            return SharedCacheMode.UNSPECIFIED;
        }
        try {
            return SharedCacheMode.valueOf((String)sharedCacheMode.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            throw new PersistenceException("Unknown ValidationMode: " + sharedCacheMode, (Throwable)ex);
        }
    }

    public static URL initJarFile(String jarFileName) {
        try {
            return new URL("file://" + jarFileName);
        }
        catch (MalformedURLException e) {
            throw new PersistenceException("Unknown jar file name: " + jarFileName, (Throwable)e);
        }
    }
}

