/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric;

import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.ContextWrapper;
import android.content.IntentFilter;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.RobolectricConfig;
import com.xtremelabs.robolectric.internal.ClassNameResolver;
import com.xtremelabs.robolectric.res.RobolectricPackageManager;
import com.xtremelabs.robolectric.shadows.ShadowApplication;
import org.w3c.dom.Document;

public class ApplicationResolver {
    RobolectricConfig config;

    public ApplicationResolver(RobolectricConfig config) {
        this.config = config;
    }

    public Application resolveApplication() {
        String applicationName = this.config.getApplicationName();
        String packageName = this.config.getPackageName();
        Application application = applicationName != null ? this.newApplicationInstance(packageName, applicationName) : new Application();
        ShadowApplication shadowApplication = Robolectric.shadowOf(application);
        shadowApplication.setPackageName(packageName);
        shadowApplication.setPackageManager(new RobolectricPackageManager((ContextWrapper)application, this.config));
        this.registerBroadcastReceivers(shadowApplication);
        return application;
    }

    private void registerBroadcastReceivers(ShadowApplication shadowApplication) {
        for (int i = 0; i < this.config.getReceiverCount(); ++i) {
            IntentFilter filter = new IntentFilter();
            for (String action : this.config.getReceiverIntentFilterActions(i)) {
                filter.addAction(action);
            }
            String receiverClassName = this.replaceLastDotWith$IfInnerStaticClass(this.config.getReceiverClassName(i));
            shadowApplication.registerReceiver((BroadcastReceiver)Robolectric.newInstanceOf(receiverClassName), filter);
        }
    }

    private String replaceLastDotWith$IfInnerStaticClass(String receiverClassName) {
        String staticInnerClassRegex;
        String[] splits = receiverClassName.split("\\.");
        if (splits[splits.length - 1].matches(staticInnerClassRegex = "[A-Z][a-zA-Z]*") && splits[splits.length - 2].matches(staticInnerClassRegex)) {
            int lastDotIndex = receiverClassName.lastIndexOf(".");
            StringBuffer buffer = new StringBuffer(receiverClassName);
            buffer.setCharAt(lastDotIndex, '$');
            return buffer.toString();
        }
        return receiverClassName;
    }

    private String getTagAttributeText(Document doc, String tag, String attribute) {
        return doc.getElementsByTagName(tag).item(0).getAttributes().getNamedItem(attribute).getTextContent();
    }

    private Application newApplicationInstance(String packageName, String applicationName) {
        Application application;
        try {
            Class applicationClass = new ClassNameResolver(packageName, applicationName).resolve();
            application = (Application)applicationClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return application;
    }
}

