/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric;

import android.app.Application;
import com.xtremelabs.robolectric.internal.ClassNameResolver;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RobolectricConfig {
    private final File androidManifestFile;
    private final File resourceDirectory;
    private final File assetsDirectory;
    private String rClassName;
    private String packageName;
    private String processName;
    private String applicationName;
    private boolean manifestIsParsed = false;
    private int sdkVersion;
    private int minSdkVersion;
    private boolean sdkVersionSpecified = true;
    private boolean minSdkVersionSpecified = true;
    private int applicationFlags;
    private final List<ReceiverAndIntentFilter> receivers = new ArrayList<ReceiverAndIntentFilter>();
    private boolean strictI18n = false;

    public RobolectricConfig(File baseDir) {
        this(new File(baseDir, "AndroidManifest.xml"), new File(baseDir, "res"), new File(baseDir, "assets"));
    }

    public RobolectricConfig(File androidManifestFile, File resourceDirectory) {
        this(androidManifestFile, resourceDirectory, new File(resourceDirectory.getParent(), "assets"));
    }

    public RobolectricConfig(File androidManifestFile, File resourceDirectory, File assetsDirectory) {
        this.androidManifestFile = androidManifestFile;
        this.resourceDirectory = resourceDirectory;
        this.assetsDirectory = assetsDirectory;
    }

    public String getRClassName() throws Exception {
        this.parseAndroidManifest();
        return this.rClassName;
    }

    public void validate() throws FileNotFoundException {
        if (!this.androidManifestFile.exists() || !this.androidManifestFile.isFile()) {
            throw new FileNotFoundException(this.androidManifestFile.getAbsolutePath() + " not found or not a file; it should point to your project's AndroidManifest.xml");
        }
        if (!this.getResourceDirectory().exists() || !this.getResourceDirectory().isDirectory()) {
            throw new FileNotFoundException(this.getResourceDirectory().getAbsolutePath() + " not found or not a directory; it should point to your project's res directory");
        }
    }

    private void parseAndroidManifest() {
        if (this.manifestIsParsed) {
            return;
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document manifestDocument = db.parse(this.androidManifestFile);
            this.packageName = RobolectricConfig.getTagAttributeText(manifestDocument, "manifest", "package");
            this.rClassName = this.packageName + ".R";
            this.applicationName = RobolectricConfig.getTagAttributeText(manifestDocument, "application", "android:name");
            Integer minSdkVer = this.getTagAttributeIntValue(manifestDocument, "uses-sdk", "android:minSdkVersion");
            Integer sdkVer = this.getTagAttributeIntValue(manifestDocument, "uses-sdk", "android:targetSdkVersion");
            if (minSdkVer == null) {
                this.minSdkVersion = 10;
                this.minSdkVersionSpecified = false;
            } else {
                this.minSdkVersion = minSdkVer;
            }
            if (sdkVer == null) {
                this.sdkVersion = 10;
                this.sdkVersionSpecified = false;
            } else {
                this.sdkVersion = sdkVer;
            }
            this.processName = RobolectricConfig.getTagAttributeText(manifestDocument, "application", "android:process");
            if (this.processName == null) {
                this.processName = this.packageName;
            }
            this.parseApplicationFlags(manifestDocument);
            this.parseReceivers(manifestDocument, this.packageName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.manifestIsParsed = true;
    }

    private void parseReceivers(Document manifestDocument, String packageName) {
        Node application = manifestDocument.getElementsByTagName("application").item(0);
        if (application == null) {
            return;
        }
        for (Node receiverNode : this.getChildrenTags(application, "receiver")) {
            Node namedItem = receiverNode.getAttributes().getNamedItem("android:name");
            if (namedItem == null) continue;
            String receiverName = namedItem.getTextContent();
            if (receiverName.startsWith(".")) {
                receiverName = packageName + receiverName;
            }
            for (Node intentFilterNode : this.getChildrenTags(receiverNode, "intent-filter")) {
                ArrayList<String> actions = new ArrayList<String>();
                for (Node actionNode : this.getChildrenTags(intentFilterNode, "action")) {
                    Node nameNode = actionNode.getAttributes().getNamedItem("android:name");
                    if (nameNode == null) continue;
                    actions.add(nameNode.getTextContent());
                }
                this.receivers.add(new ReceiverAndIntentFilter(receiverName, actions));
            }
        }
    }

    private List<Node> getChildrenTags(Node node, String tagName) {
        ArrayList<Node> children = new ArrayList<Node>();
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            Node childNode = node.getChildNodes().item(i);
            if (!childNode.getNodeName().equalsIgnoreCase(tagName)) continue;
            children.add(childNode);
        }
        return children;
    }

    private void parseApplicationFlags(Document manifestDocument) {
        this.applicationFlags = this.getApplicationFlag(manifestDocument, "android:allowBackup", 32768);
        this.applicationFlags += this.getApplicationFlag(manifestDocument, "android:allowClearUserData", 64);
        this.applicationFlags += this.getApplicationFlag(manifestDocument, "android:allowTaskReparenting", 32);
        this.applicationFlags += this.getApplicationFlag(manifestDocument, "android:debuggable", 2);
        this.applicationFlags += this.getApplicationFlag(manifestDocument, "android:hasCode", 4);
        this.applicationFlags += this.getApplicationFlag(manifestDocument, "android:killAfterRestore", 65536);
        this.applicationFlags += this.getApplicationFlag(manifestDocument, "android:persistent", 8);
        this.applicationFlags += this.getApplicationFlag(manifestDocument, "android:resizeable", 4096);
        this.applicationFlags += this.getApplicationFlag(manifestDocument, "android:restoreAnyVersion", 131072);
        this.applicationFlags += this.getApplicationFlag(manifestDocument, "android:largeScreens", 2048);
        this.applicationFlags += this.getApplicationFlag(manifestDocument, "android:normalScreens", 1024);
        this.applicationFlags += this.getApplicationFlag(manifestDocument, "android:anyDensity", 8192);
        this.applicationFlags += this.getApplicationFlag(manifestDocument, "android:smallScreens", 512);
        this.applicationFlags += this.getApplicationFlag(manifestDocument, "android:testOnly", 256);
        this.applicationFlags += this.getApplicationFlag(manifestDocument, "android:vmSafeMode", 16384);
    }

    private int getApplicationFlag(Document doc, String attribute, int attributeValue) {
        String flagString = RobolectricConfig.getTagAttributeText(doc, "application", attribute);
        return "true".equalsIgnoreCase(flagString) ? attributeValue : 0;
    }

    private Integer getTagAttributeIntValue(Document doc, String tag, String attribute) {
        return this.getTagAttributeIntValue(doc, tag, attribute, null);
    }

    private Integer getTagAttributeIntValue(Document doc, String tag, String attribute, Integer defaultValue) {
        String valueString = RobolectricConfig.getTagAttributeText(doc, tag, attribute);
        if (valueString != null) {
            return Integer.parseInt(valueString);
        }
        return defaultValue;
    }

    public String getApplicationName() {
        this.parseAndroidManifest();
        return this.applicationName;
    }

    public String getPackageName() {
        this.parseAndroidManifest();
        return this.packageName;
    }

    public int getMinSdkVersion() {
        this.parseAndroidManifest();
        return this.minSdkVersion;
    }

    public int getSdkVersion() {
        this.parseAndroidManifest();
        return this.sdkVersion;
    }

    public int getApplicationFlags() {
        this.parseAndroidManifest();
        return this.applicationFlags;
    }

    public String getProcessName() {
        this.parseAndroidManifest();
        return this.processName;
    }

    public File getResourceDirectory() {
        return this.resourceDirectory;
    }

    public File getAssetsDirectory() {
        return this.assetsDirectory;
    }

    public int getReceiverCount() {
        this.parseAndroidManifest();
        return this.receivers.size();
    }

    public String getReceiverClassName(int receiverIndex) {
        this.parseAndroidManifest();
        return this.receivers.get(receiverIndex).getBroadcastReceiverClassName();
    }

    public List<String> getReceiverIntentFilterActions(int receiverIndex) {
        this.parseAndroidManifest();
        return this.receivers.get(receiverIndex).getIntentFilterActions();
    }

    public boolean getStrictI18n() {
        return this.strictI18n;
    }

    public void setStrictI18n(boolean strict) {
        this.strictI18n = strict;
    }

    private static String getTagAttributeText(Document doc, String tag, String attribute) {
        NodeList elementsByTagName = doc.getElementsByTagName(tag);
        for (int i = 0; i < elementsByTagName.getLength(); ++i) {
            Node item = elementsByTagName.item(i);
            Node namedItem = item.getAttributes().getNamedItem(attribute);
            if (namedItem == null) continue;
            return namedItem.getTextContent();
        }
        return null;
    }

    private static Application newApplicationInstance(String packageName, String applicationName) {
        Application application;
        try {
            Class applicationClass = new ClassNameResolver(packageName, applicationName).resolve();
            application = (Application)applicationClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return application;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RobolectricConfig that = (RobolectricConfig)o;
        if (this.androidManifestFile != null ? !this.androidManifestFile.equals(that.androidManifestFile) : that.androidManifestFile != null) {
            return false;
        }
        if (this.getAssetsDirectory() != null ? !this.getAssetsDirectory().equals(that.getAssetsDirectory()) : that.getAssetsDirectory() != null) {
            return false;
        }
        return !(this.getResourceDirectory() != null ? !this.getResourceDirectory().equals(that.getResourceDirectory()) : that.getResourceDirectory() != null);
    }

    public int hashCode() {
        int result = this.androidManifestFile != null ? this.androidManifestFile.hashCode() : 0;
        result = 31 * result + (this.getResourceDirectory() != null ? this.getResourceDirectory().hashCode() : 0);
        result = 31 * result + (this.getAssetsDirectory() != null ? this.getAssetsDirectory().hashCode() : 0);
        return result;
    }

    public int getRealSdkVersion() {
        this.parseAndroidManifest();
        if (this.sdkVersionSpecified) {
            return this.sdkVersion;
        }
        if (this.minSdkVersionSpecified) {
            return this.minSdkVersion;
        }
        return this.sdkVersion;
    }

    private static class ReceiverAndIntentFilter {
        private final List<String> intentFilterActions;
        private final String broadcastReceiverClassName;

        public ReceiverAndIntentFilter(String broadcastReceiverClassName, List<String> intentFilterActions) {
            this.broadcastReceiverClassName = broadcastReceiverClassName;
            this.intentFilterActions = intentFilterActions;
        }

        public String getBroadcastReceiverClassName() {
            return this.broadcastReceiverClassName;
        }

        public List<String> getIntentFilterActions() {
            return this.intentFilterActions;
        }
    }
}

