/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric;

import android.R;
import android.app.Application;
import android.net.Uri__FromAndroid;
import com.xtremelabs.robolectric.ApplicationResolver;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.RobolectricConfig;
import com.xtremelabs.robolectric.bytecode.ClassHandler;
import com.xtremelabs.robolectric.bytecode.RobolectricClassLoader;
import com.xtremelabs.robolectric.bytecode.ShadowWrangler;
import com.xtremelabs.robolectric.internal.RealObject;
import com.xtremelabs.robolectric.internal.RobolectricTestRunnerInterface;
import com.xtremelabs.robolectric.res.ResourceLoader;
import com.xtremelabs.robolectric.shadows.ShadowApplication;
import com.xtremelabs.robolectric.shadows.ShadowLog;
import com.xtremelabs.robolectric.util.DatabaseConfig;
import com.xtremelabs.robolectric.util.SQLiteMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javassist.Loader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class RobolectricTestRunner
extends BlockJUnit4ClassRunner
implements RobolectricTestRunnerInterface {
    private static InstrumentDetector instrumentDetector = InstrumentDetector.DEFAULT;
    private static RobolectricClassLoader defaultLoader;
    private static Map<RobolectricConfig, ResourceLoader> resourceLoaderForRootAndDirectory;
    private RobolectricClassLoader classLoader;
    private ClassHandler classHandler;
    private RobolectricTestRunnerInterface delegate;
    private DatabaseConfig.DatabaseMap databaseMap;
    protected RobolectricConfig robolectricConfig;

    private static RobolectricClassLoader getDefaultLoader() {
        if (defaultLoader == null) {
            defaultLoader = new RobolectricClassLoader(ShadowWrangler.getInstance());
        }
        return defaultLoader;
    }

    public static void setInstrumentDetector(InstrumentDetector detector) {
        instrumentDetector = detector;
    }

    public static void setDefaultLoader(Loader robolectricClassLoader) {
        if (defaultLoader != null) {
            throw new RuntimeException("You may not set the default robolectricClassLoader unless it is null!");
        }
        defaultLoader = (RobolectricClassLoader)robolectricClassLoader;
    }

    protected static void addClassOrPackageToInstrument(String classOrPackageToBeInstrumented) {
        if (!RobolectricTestRunner.isInstrumented()) {
            defaultLoader.addCustomShadowClass(classOrPackageToBeInstrumented);
        }
    }

    public RobolectricTestRunner(Class<?> testClass) throws InitializationError {
        this(testClass, new RobolectricConfig(new File(".")));
    }

    protected RobolectricTestRunner(Class<?> testClass, RobolectricConfig robolectricConfig) throws InitializationError {
        this(testClass, RobolectricTestRunner.isInstrumented() ? null : ShadowWrangler.getInstance(), RobolectricTestRunner.isInstrumented() ? null : RobolectricTestRunner.getDefaultLoader(), robolectricConfig, new SQLiteMap());
    }

    protected RobolectricTestRunner(Class<?> testClass, RobolectricConfig robolectricConfig, DatabaseConfig.DatabaseMap databaseMap) throws InitializationError {
        this(testClass, RobolectricTestRunner.isInstrumented() ? null : ShadowWrangler.getInstance(), RobolectricTestRunner.isInstrumented() ? null : RobolectricTestRunner.getDefaultLoader(), robolectricConfig, databaseMap);
    }

    public RobolectricTestRunner(Class<?> testClass, File androidProjectRoot) throws InitializationError {
        this(testClass, new RobolectricConfig(androidProjectRoot));
    }

    @Deprecated
    public RobolectricTestRunner(Class<?> testClass, String androidProjectRoot) throws InitializationError {
        this(testClass, new RobolectricConfig(new File(androidProjectRoot)));
    }

    protected RobolectricTestRunner(Class<?> testClass, File androidManifestPath, File resourceDirectory) throws InitializationError {
        this(testClass, new RobolectricConfig(androidManifestPath, resourceDirectory));
    }

    @Deprecated
    protected RobolectricTestRunner(Class<?> testClass, String androidManifestPath, String resourceDirectory) throws InitializationError {
        this(testClass, new RobolectricConfig(new File(androidManifestPath), new File(resourceDirectory)));
    }

    protected RobolectricTestRunner(Class<?> testClass, ClassHandler classHandler, RobolectricClassLoader classLoader, RobolectricConfig robolectricConfig) throws InitializationError {
        this(testClass, classHandler, classLoader, robolectricConfig, new SQLiteMap());
    }

    protected RobolectricTestRunner(Class<?> testClass, ClassHandler classHandler, RobolectricClassLoader classLoader, RobolectricConfig robolectricConfig, DatabaseConfig.DatabaseMap map) throws InitializationError {
        super(RobolectricTestRunner.isInstrumented() ? testClass : classLoader.bootstrap(testClass));
        if (!RobolectricTestRunner.isInstrumented()) {
            this.classHandler = classHandler;
            this.classLoader = classLoader;
            this.robolectricConfig = robolectricConfig;
            this.databaseMap = this.setupDatabaseMap(testClass, map);
            Thread.currentThread().setContextClassLoader((ClassLoader)((Object)classLoader));
            this.delegateLoadingOf(Uri__FromAndroid.class.getName());
            this.delegateLoadingOf(RobolectricTestRunnerInterface.class.getName());
            this.delegateLoadingOf(RealObject.class.getName());
            this.delegateLoadingOf(ShadowWrangler.class.getName());
            this.delegateLoadingOf(RobolectricConfig.class.getName());
            this.delegateLoadingOf(DatabaseConfig.DatabaseMap.class.getName());
            this.delegateLoadingOf(R.class.getName());
            Class<?> delegateClass = classLoader.bootstrap(this.getClass());
            try {
                Constructor<?> constructorForDelegate = delegateClass.getConstructor(Class.class);
                this.delegate = (RobolectricTestRunnerInterface)constructorForDelegate.newInstance(classLoader.bootstrap(testClass));
                this.delegate.setRobolectricConfig(robolectricConfig);
                this.delegate.setDatabaseMap(this.databaseMap);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected static boolean isInstrumented() {
        return instrumentDetector.isInstrumented();
    }

    protected RobolectricTestRunner(Class<?> testClass, ClassHandler classHandler, RobolectricConfig robolectricConfig) throws InitializationError {
        super(testClass);
        this.classHandler = classHandler;
        this.robolectricConfig = robolectricConfig;
    }

    public static void setStaticValue(Class<?> clazz, String fieldName, Object value) {
        try {
            Field field = clazz.getField(fieldName);
            field.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.set(null, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void delegateLoadingOf(String className) {
        this.classLoader.delegateLoadingOf(className);
    }

    protected Statement methodBlock(final FrameworkMethod method) {
        this.setupI18nStrictState(method.getMethod(), this.robolectricConfig);
        if (this.classHandler != null) {
            this.classHandler.configure(this.robolectricConfig);
            this.classHandler.beforeTest();
        }
        this.delegate.internalBeforeTest(method.getMethod());
        final Statement statement = super.methodBlock(method);
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                try {
                    statement.evaluate();
                }
                finally {
                    RobolectricTestRunner.this.delegate.internalAfterTest(method.getMethod());
                    if (RobolectricTestRunner.this.classHandler != null) {
                        RobolectricTestRunner.this.classHandler.afterTest();
                    }
                }
            }
        };
    }

    @Override
    public void internalBeforeTest(Method method) {
        this.setupApplicationState(this.robolectricConfig);
        this.beforeTest(method);
    }

    @Override
    public void internalAfterTest(Method method) {
        this.afterTest(method);
    }

    @Override
    public void setRobolectricConfig(RobolectricConfig robolectricConfig) {
        this.robolectricConfig = robolectricConfig;
    }

    public void beforeTest(Method method) {
    }

    public void afterTest(Method method) {
    }

    @Override
    public Object createTest() throws Exception {
        if (this.delegate != null) {
            return this.delegate.createTest();
        }
        Object test = super.createTest();
        this.prepareTest(test);
        return test;
    }

    public void prepareTest(Object test) {
    }

    public void setupApplicationState(RobolectricConfig robolectricConfig) {
        this.setupLogging();
        ResourceLoader resourceLoader = this.createResourceLoader(robolectricConfig);
        Robolectric.bindDefaultShadowClasses();
        this.bindShadowClasses();
        resourceLoader.setLayoutQualifierSearchPath(new String[0]);
        Robolectric.resetStaticState();
        this.resetStaticState();
        DatabaseConfig.setDatabaseMap(this.databaseMap);
        Robolectric.application = ShadowApplication.bind(this.createApplication(), resourceLoader);
    }

    protected void bindShadowClasses() {
    }

    protected void resetStaticState() {
    }

    private void setupI18nStrictState(Method method, RobolectricConfig robolectricConfig) {
        boolean strictI18n = this.globalI18nStrictEnabled();
        Annotation[] annos = method.getDeclaringClass().getAnnotations();
        strictI18n = this.lookForI18nAnnotations(strictI18n, annos);
        annos = method.getAnnotations();
        strictI18n = this.lookForI18nAnnotations(strictI18n, annos);
        robolectricConfig.setStrictI18n(strictI18n);
    }

    protected boolean globalI18nStrictEnabled() {
        return Boolean.valueOf(System.getProperty("robolectric.strictI18n"));
    }

    private boolean lookForI18nAnnotations(boolean strictI18n, Annotation[] annos) {
        for (int i = 0; i < annos.length; ++i) {
            String name = annos[i].annotationType().getName();
            if (name.equals("com.xtremelabs.robolectric.annotation.EnableStrictI18n")) {
                strictI18n = true;
                break;
            }
            if (!name.equals("com.xtremelabs.robolectric.annotation.DisableStrictI18n")) continue;
            strictI18n = false;
            break;
        }
        return strictI18n;
    }

    private void setupLogging() {
        String logging = System.getProperty("robolectric.logging");
        if (logging != null && ShadowLog.stream == null) {
            PrintStream stream = null;
            if ("stdout".equalsIgnoreCase(logging)) {
                stream = System.out;
            } else if ("stderr".equalsIgnoreCase(logging)) {
                stream = System.err;
            } else {
                try {
                    PrintStream file;
                    stream = file = new PrintStream(new FileOutputStream(logging));
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        @Override
                        public void run() {
                            try {
                                file.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ShadowLog.stream = stream;
        }
    }

    protected Application createApplication() {
        return new ApplicationResolver(this.robolectricConfig).resolveApplication();
    }

    private ResourceLoader createResourceLoader(RobolectricConfig robolectricConfig) {
        ResourceLoader resourceLoader = resourceLoaderForRootAndDirectory.get(robolectricConfig);
        if (resourceLoader == null) {
            try {
                robolectricConfig.validate();
                String rClassName = robolectricConfig.getRClassName();
                Class<?> rClass = Class.forName(rClassName);
                resourceLoader = new ResourceLoader(robolectricConfig.getRealSdkVersion(), rClass, robolectricConfig.getResourceDirectory(), robolectricConfig.getAssetsDirectory());
                resourceLoaderForRootAndDirectory.put(robolectricConfig, resourceLoader);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        resourceLoader.setStrictI18n(robolectricConfig.getStrictI18n());
        return resourceLoader;
    }

    private String findResourcePackageName(File projectManifestFile) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(projectManifestFile);
        String projectPackage = doc.getElementsByTagName("manifest").item(0).getAttributes().getNamedItem("package").getTextContent();
        return projectPackage + ".R";
    }

    protected DatabaseConfig.DatabaseMap setupDatabaseMap(Class<?> testClass, DatabaseConfig.DatabaseMap map) {
        DatabaseConfig.DatabaseMap dbMap = map;
        if (testClass.isAnnotationPresent(DatabaseConfig.UsingDatabaseMap.class)) {
            DatabaseConfig.UsingDatabaseMap usingMap = testClass.getAnnotation(DatabaseConfig.UsingDatabaseMap.class);
            if (usingMap.value() != null) {
                dbMap = Robolectric.newInstanceOf(usingMap.value());
            } else if (dbMap == null) {
                throw new RuntimeException("UsingDatabaseMap annotation value must provide a class implementing DatabaseMap");
            }
        }
        return dbMap;
    }

    public DatabaseConfig.DatabaseMap getDatabaseMap() {
        return this.databaseMap;
    }

    @Override
    public void setDatabaseMap(DatabaseConfig.DatabaseMap databaseMap) {
        this.databaseMap = databaseMap;
    }

    static {
        resourceLoaderForRootAndDirectory = new HashMap<RobolectricConfig, ResourceLoader>();
    }

    public static interface InstrumentDetector {
        public static final InstrumentDetector DEFAULT = new InstrumentDetector(){

            @Override
            public boolean isInstrumented() {
                return RobolectricTestRunner.class.getClassLoader().getClass().getName().contains(RobolectricClassLoader.class.getName());
            }
        };

        public boolean isInstrumented();
    }
}

