/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.bytecode;

import android.net.Uri;
import com.xtremelabs.robolectric.bytecode.ClassCache;
import com.xtremelabs.robolectric.bytecode.ClassHandler;
import com.xtremelabs.robolectric.bytecode.IgnorableClassNotFoundException;
import com.xtremelabs.robolectric.bytecode.RobolectricInternals;
import com.xtremelabs.robolectric.bytecode.Type;
import com.xtremelabs.robolectric.internal.DoNotInstrument;
import com.xtremelabs.robolectric.internal.Instrument;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javassist.CannotCompileException;
import javassist.ClassMap;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.Translator;

public class AndroidTranslator
implements Translator {
    public static final int CACHE_VERSION = 20;
    private static final List<ClassHandler> CLASS_HANDLERS = new ArrayList<ClassHandler>();
    private ClassHandler classHandler;
    private ClassCache classCache;
    private static final ArrayList<String> instrumentingList = new ArrayList();

    public AndroidTranslator(ClassHandler classHandler, ClassCache classCache) {
        this.classHandler = classHandler;
        this.classCache = classCache;
        instrumentingList.add("android.");
        instrumentingList.add("com.google.android.maps");
        instrumentingList.add("org.apache.http.impl.client.DefaultRequestDirector");
    }

    public AndroidTranslator(ClassHandler classHandler, ClassCache classCache, List<String> customShadowClassNames) {
        this(classHandler, classCache);
        if (customShadowClassNames != null && !customShadowClassNames.isEmpty()) {
            instrumentingList.addAll(customShadowClassNames);
        }
    }

    public void addCustomShadowClass(String customShadowClassName) {
        if (!instrumentingList.contains(customShadowClassName)) {
            instrumentingList.add(customShadowClassName);
        }
    }

    public static ClassHandler getClassHandler(int index) {
        return CLASS_HANDLERS.get(index);
    }

    public void start(ClassPool classPool) throws NotFoundException, CannotCompileException {
        this.injectClassHandlerToInstrumentedClasses(classPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void injectClassHandlerToInstrumentedClasses(ClassPool classPool) throws NotFoundException, CannotCompileException {
        int index;
        List<ClassHandler> list = CLASS_HANDLERS;
        synchronized (list) {
            CLASS_HANDLERS.add(this.classHandler);
            index = CLASS_HANDLERS.size() - 1;
        }
        CtClass robolectricInternalsCtClass = classPool.get(RobolectricInternals.class.getName());
        robolectricInternalsCtClass.setModifiers(1);
        robolectricInternalsCtClass.getClassInitializer().insertBefore("{\nclassHandler = " + AndroidTranslator.class.getName() + ".getClassHandler(" + index + ");\n" + "}");
    }

    public void onLoad(ClassPool classPool, String className) throws NotFoundException, CannotCompileException {
        CtClass ctClass;
        if (this.classCache.isWriting()) {
            throw new IllegalStateException("shouldn't be modifying bytecode after we've started writing cache! class=" + className);
        }
        if (this.classHasFromAndroidEquivalent(className)) {
            this.replaceClassWithFromAndroidEquivalent(classPool, className);
            return;
        }
        try {
            ctClass = classPool.get(className);
        }
        catch (NotFoundException e) {
            throw new IgnorableClassNotFoundException(e);
        }
        boolean wantsToBeInstrumented = ctClass.hasAnnotation(Instrument.class);
        if (!wantsToBeInstrumented) {
            String klassName;
            Iterator<String> i$ = instrumentingList.iterator();
            while (i$.hasNext() && !(wantsToBeInstrumented = className.startsWith(klassName = i$.next()))) {
            }
        }
        if (wantsToBeInstrumented && !ctClass.hasAnnotation(DoNotInstrument.class)) {
            int modifiers = ctClass.getModifiers();
            if (Modifier.isFinal((int)modifiers)) {
                ctClass.setModifiers(modifiers & 0xFFFFFFEF);
            }
            if (ctClass.isInterface()) {
                return;
            }
            this.classHandler.instrument(ctClass);
            this.fixConstructors(ctClass);
            this.fixMethods(ctClass);
            try {
                this.classCache.addClass(className, ctClass.toBytecode());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private boolean classHasFromAndroidEquivalent(String className) {
        return className.startsWith(Uri.class.getName());
    }

    private void replaceClassWithFromAndroidEquivalent(ClassPool classPool, String className) throws NotFoundException {
        FromAndroidClassNameParts classNameParts = new FromAndroidClassNameParts(className);
        if (classNameParts.isFromAndroid()) {
            return;
        }
        String from = classNameParts.getNameWithFromAndroid();
        CtClass ctClass = classPool.getAndRename(from, className);
        ClassMap map = new ClassMap(){

            public Object get(Object jvmClassName) {
                FromAndroidClassNameParts classNameParts = new FromAndroidClassNameParts(jvmClassName.toString());
                if (classNameParts.isFromAndroid()) {
                    return classNameParts.getNameWithoutFromAndroid();
                }
                return jvmClassName;
            }
        };
        ctClass.replaceClassName(map);
    }

    private void addBypassShadowField(CtClass ctClass, String fieldName) {
        try {
            try {
                ctClass.getField(fieldName);
            }
            catch (NotFoundException e) {
                CtField field = new CtField(CtClass.booleanType, fieldName, ctClass);
                field.setModifiers(9);
                ctClass.addField(field);
            }
        }
        catch (CannotCompileException e) {
            throw new RuntimeException(e);
        }
    }

    private void fixConstructors(CtClass ctClass) throws CannotCompileException, NotFoundException {
        if (ctClass.isEnum()) {
            return;
        }
        boolean hasDefault = false;
        for (CtConstructor ctConstructor : ctClass.getDeclaredConstructors()) {
            try {
                this.fixConstructor(ctClass, hasDefault, ctConstructor);
                if (ctConstructor.getParameterTypes().length != 0) continue;
                hasDefault = true;
            }
            catch (Exception e) {
                throw new RuntimeException("problem instrumenting " + ctConstructor, e);
            }
        }
        if (!hasDefault) {
            String methodBody = this.generateConstructorBody(ctClass, new CtClass[0]);
            ctClass.addConstructor(CtNewConstructor.make((CtClass[])new CtClass[0], (CtClass[])new CtClass[0], (String)("{\n" + methodBody + "}\n"), (CtClass)ctClass));
        }
    }

    private boolean fixConstructor(CtClass ctClass, boolean needsDefault, CtConstructor ctConstructor) throws NotFoundException, CannotCompileException {
        String methodBody = this.generateConstructorBody(ctClass, ctConstructor.getParameterTypes());
        ctConstructor.setBody("{\n" + methodBody + "}\n");
        return needsDefault;
    }

    private String generateConstructorBody(CtClass ctClass, CtClass[] parameterTypes) throws NotFoundException {
        return this.generateMethodBody(ctClass, new CtMethod(CtClass.voidType, "<init>", parameterTypes, ctClass), CtClass.voidType, Type.VOID, false, false);
    }

    private void fixMethods(CtClass ctClass) throws NotFoundException, CannotCompileException {
        for (CtMethod ctMethod : ctClass.getDeclaredMethods()) {
            this.fixMethod(ctClass, ctMethod, true);
        }
        CtMethod equalsMethod = ctClass.getMethod("equals", "(Ljava/lang/Object;)Z");
        CtMethod hashCodeMethod = ctClass.getMethod("hashCode", "()I");
        CtMethod toStringMethod = ctClass.getMethod("toString", "()Ljava/lang/String;");
        this.fixMethod(ctClass, equalsMethod, false);
        this.fixMethod(ctClass, hashCodeMethod, false);
        this.fixMethod(ctClass, toStringMethod, false);
    }

    private String describe(CtMethod ctMethod) throws NotFoundException {
        return Modifier.toString((int)ctMethod.getModifiers()) + " " + ctMethod.getReturnType().getSimpleName() + " " + ctMethod.getLongName();
    }

    private void fixMethod(CtClass ctClass, CtMethod ctMethod, boolean wasFoundInClass) throws NotFoundException {
        String describeBefore = this.describe(ctMethod);
        try {
            boolean wasDeclaredInClass;
            CtClass declaringClass = ctMethod.getDeclaringClass();
            int originalModifiers = ctMethod.getModifiers();
            boolean wasNative = Modifier.isNative((int)originalModifiers);
            boolean wasFinal = Modifier.isFinal((int)originalModifiers);
            boolean wasAbstract = Modifier.isAbstract((int)originalModifiers);
            boolean bl = wasDeclaredInClass = ctClass == declaringClass;
            if (wasFinal && ctClass.isEnum()) {
                return;
            }
            int newModifiers = originalModifiers;
            if (wasNative) {
                newModifiers = Modifier.clear((int)newModifiers, (int)256);
            }
            if (wasFinal) {
                newModifiers = Modifier.clear((int)newModifiers, (int)16);
            }
            if (wasFoundInClass) {
                ctMethod.setModifiers(newModifiers);
            }
            CtClass returnCtClass = ctMethod.getReturnType();
            Type returnType = Type.find(returnCtClass);
            String methodName = ctMethod.getName();
            CtClass[] paramTypes = ctMethod.getParameterTypes();
            boolean isStatic = Modifier.isStatic((int)originalModifiers);
            String methodBody = this.generateMethodBody(ctClass, ctMethod, wasNative, wasAbstract, returnCtClass, returnType, isStatic, !wasFoundInClass);
            if (!wasFoundInClass) {
                CtMethod newMethod = this.makeNewMethod(ctClass, ctMethod, returnCtClass, methodName, paramTypes, "{\n" + methodBody + this.generateCallToSuper(methodName, paramTypes) + "\n}");
                newMethod.setModifiers(newModifiers);
                if (wasDeclaredInClass) {
                    ctMethod.insertBefore("{\n" + methodBody + "}\n");
                } else {
                    ctClass.addMethod(newMethod);
                }
            } else if (wasAbstract || wasNative) {
                CtMethod newMethod = this.makeNewMethod(ctClass, ctMethod, returnCtClass, methodName, paramTypes, "{\n" + methodBody + "\n}");
                ctMethod.setBody(newMethod, null);
            } else {
                ctMethod.insertBefore("{\n" + methodBody + "}\n");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("problem instrumenting " + describeBefore, e);
        }
    }

    private CtMethod makeNewMethod(CtClass ctClass, CtMethod ctMethod, CtClass returnCtClass, String methodName, CtClass[] paramTypes, String methodBody) throws CannotCompileException, NotFoundException {
        return CtNewMethod.make((int)ctMethod.getModifiers(), (CtClass)returnCtClass, (String)methodName, (CtClass[])paramTypes, (CtClass[])ctMethod.getExceptionTypes(), (String)methodBody, (CtClass)ctClass);
    }

    public String generateCallToSuper(String methodName, CtClass[] paramTypes) {
        return "return super." + methodName + "(" + this.makeParameterReplacementList(paramTypes.length) + ");";
    }

    public String makeParameterReplacementList(int length) {
        if (length == 0) {
            return "";
        }
        String parameterReplacementList = "$1";
        for (int i = 2; i <= length; ++i) {
            parameterReplacementList = parameterReplacementList + ", $" + i;
        }
        return parameterReplacementList;
    }

    private String generateMethodBody(CtClass ctClass, CtMethod ctMethod, boolean wasNative, boolean wasAbstract, CtClass returnCtClass, Type returnType, boolean aStatic, boolean shouldGenerateCallToSuper) throws NotFoundException {
        String methodBody = wasAbstract ? (returnType.isVoid() ? "" : "return " + returnType.defaultReturnString() + ";") : this.generateMethodBody(ctClass, ctMethod, returnCtClass, returnType, aStatic, shouldGenerateCallToSuper);
        if (wasNative) {
            methodBody = methodBody + (returnType.isVoid() ? "" : "return " + returnType.defaultReturnString() + ";");
        }
        return methodBody;
    }

    public String generateMethodBody(CtClass ctClass, CtMethod ctMethod, CtClass returnCtClass, Type returnType, boolean isStatic, boolean shouldGenerateCallToSuper) throws NotFoundException {
        boolean returnsVoid = returnType.isVoid();
        String className = ctClass.getName();
        StringBuilder buf = new StringBuilder();
        buf.append("if (!");
        buf.append(RobolectricInternals.class.getName());
        buf.append(".shouldCallDirectly(");
        buf.append(isStatic ? className + ".class" : "this");
        buf.append(")) {\n");
        if (!returnsVoid) {
            buf.append("Object x = ");
        }
        buf.append(RobolectricInternals.class.getName());
        buf.append(".methodInvoked(\n  ");
        buf.append(className);
        buf.append(".class, \"");
        buf.append(ctMethod.getName());
        buf.append("\", ");
        if (!isStatic) {
            buf.append("this");
        } else {
            buf.append("null");
        }
        buf.append(", ");
        this.appendParamTypeArray(buf, ctMethod);
        buf.append(", ");
        this.appendParamArray(buf, ctMethod);
        buf.append(")");
        buf.append(";\n");
        if (!returnsVoid) {
            buf.append("if (x != null) return ((");
            buf.append(returnType.nonPrimitiveClassName(returnCtClass));
            buf.append(") x)");
            buf.append(returnType.unboxString());
            buf.append(";\n");
            if (shouldGenerateCallToSuper) {
                buf.append(this.generateCallToSuper(ctMethod.getName(), ctMethod.getParameterTypes()));
            } else {
                buf.append("return ");
                buf.append(returnType.defaultReturnString());
                buf.append(";\n");
            }
        } else {
            buf.append("return;\n");
        }
        buf.append("}\n");
        String methodBody = buf.toString();
        return methodBody;
    }

    private void appendParamTypeArray(StringBuilder buf, CtMethod ctMethod) throws NotFoundException {
        CtClass[] parameterTypes = ctMethod.getParameterTypes();
        if (parameterTypes.length == 0) {
            buf.append("new String[0]");
        } else {
            buf.append("new String[] {");
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append("\"");
                CtClass parameterType = parameterTypes[i];
                buf.append(parameterType.getName());
                buf.append("\"");
            }
            buf.append("}");
        }
    }

    private void appendParamArray(StringBuilder buf, CtMethod ctMethod) throws NotFoundException {
        int parameterCount = ctMethod.getParameterTypes().length;
        if (parameterCount == 0) {
            buf.append("new Object[0]");
        } else {
            buf.append("new Object[] {");
            for (int i = 0; i < parameterCount; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(RobolectricInternals.class.getName());
                buf.append(".autobox(");
                buf.append("$").append(i + 1);
                buf.append(")");
            }
            buf.append("}");
        }
    }

    private boolean declareField(CtClass ctClass, String fieldName, CtClass fieldType) throws CannotCompileException, NotFoundException {
        CtMethod ctMethod = this.getMethod(ctClass, "get" + fieldName, "");
        if (ctMethod == null) {
            return false;
        }
        CtClass getterFieldType = ctMethod.getReturnType();
        if (!getterFieldType.equals(fieldType)) {
            return false;
        }
        if (this.getField(ctClass, fieldName) == null) {
            CtField field = new CtField(fieldType, fieldName, ctClass);
            field.setModifiers(2);
            ctClass.addField(field);
        }
        return true;
    }

    private CtField getField(CtClass ctClass, String fieldName) {
        try {
            return ctClass.getField(fieldName);
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    private CtMethod getMethod(CtClass ctClass, String methodName, String desc) {
        try {
            return ctClass.getMethod(methodName, desc);
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    class FromAndroidClassNameParts {
        private static final String TOKEN = "__FromAndroid";
        private String prefix;
        private String suffix;

        FromAndroidClassNameParts(String name) {
            int dollarIndex = name.indexOf("$");
            this.prefix = name;
            this.suffix = "";
            if (dollarIndex > -1) {
                this.prefix = name.substring(0, dollarIndex);
                this.suffix = name.substring(dollarIndex);
            }
        }

        public boolean isFromAndroid() {
            return this.prefix.endsWith(TOKEN);
        }

        public String getNameWithFromAndroid() {
            return this.prefix + TOKEN + this.suffix;
        }

        public String getNameWithoutFromAndroid() {
            return this.prefix.replace(TOKEN, "") + this.suffix;
        }
    }
}

