/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.bytecode;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipOutputStream;

public class ClassCache {
    private static final Attributes.Name VERSION_ATTRIBUTE = new Attributes.Name("version");
    private Map<String, byte[]> cachedClasses = new HashMap<String, byte[]>();
    private boolean startedWriting = false;

    public ClassCache(String classCachePath, final int expectedCacheVersion) {
        final File cacheJarFile = new File(classCachePath);
        try {
            String cacheVersionStr;
            Attributes attributes;
            JarFile cacheFile = new JarFile(cacheJarFile);
            int cacheVersion = 0;
            Manifest manifest = cacheFile.getManifest();
            if (manifest != null && (attributes = manifest.getEntries().get("robolectric")) != null && (cacheVersionStr = (String)attributes.get(VERSION_ATTRIBUTE)) != null) {
                cacheVersion = Integer.parseInt(cacheVersionStr);
            }
            if (cacheVersion != expectedCacheVersion) {
                cacheJarFile.delete();
            } else {
                this.readEntries(cacheFile);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Manifest manifest = new Manifest();
                Attributes attributes = new Attributes();
                attributes.put(VERSION_ATTRIBUTE, String.valueOf(expectedCacheVersion));
                manifest.getEntries().put("robolectric", attributes);
                ClassCache.this.saveAllClassesToCache(cacheJarFile, manifest);
            }
        });
    }

    public byte[] getClassBytesFor(String name) {
        return this.cachedClasses.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWriting() {
        ClassCache classCache = this;
        synchronized (classCache) {
            return this.startedWriting;
        }
    }

    public void addClass(String className, byte[] classBytes) {
        this.cachedClasses.put(className, classBytes);
    }

    private void readEntries(JarFile cacheFile) {
        Enumeration<JarEntry> entries = cacheFile.entries();
        try {
            while (entries.hasMoreElements()) {
                int c;
                JarEntry entry = entries.nextElement();
                String className = entry.getName();
                if (!className.endsWith(".class")) continue;
                int classSize = (int)entry.getSize();
                InputStream inputStream = cacheFile.getInputStream(entry);
                ByteArrayOutputStream baos = new ByteArrayOutputStream(classSize);
                while ((c = inputStream.read()) != -1) {
                    baos.write(c);
                }
                className = className.substring(0, className.indexOf(".class")).replace('/', '.');
                this.addClass(className, baos.toByteArray());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveAllClassesToCache(File file, Manifest manifest) {
        ClassCache classCache = this;
        synchronized (classCache) {
            this.startedWriting = true;
            if (this.cachedClasses.size() > 0) {
                ZipOutputStream jarOutputStream = null;
                try {
                    File cacheJarDir = file.getParentFile();
                    if (!cacheJarDir.exists()) {
                        cacheJarDir.mkdirs();
                    }
                    jarOutputStream = new JarOutputStream((OutputStream)new FileOutputStream(file), manifest);
                    for (Map.Entry<String, byte[]> entry : this.cachedClasses.entrySet()) {
                        String key = entry.getKey();
                        ((JarOutputStream)jarOutputStream).putNextEntry(new JarEntry(key.replace('.', '/') + ".class"));
                        jarOutputStream.write(entry.getValue());
                        jarOutputStream.closeEntry();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (jarOutputStream != null) {
                        try {
                            jarOutputStream.close();
                        }
                        catch (IOException ignore) {}
                    }
                }
            }
            this.startedWriting = false;
        }
    }
}

