/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.bytecode;

import com.xtremelabs.robolectric.bytecode.AndroidTranslator;
import com.xtremelabs.robolectric.bytecode.ClassCache;
import com.xtremelabs.robolectric.bytecode.ClassHandler;
import java.io.File;
import java.util.List;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.Loader;
import javassist.LoaderClassPath;
import javassist.NotFoundException;

public class RobolectricClassLoader
extends Loader {
    private ClassCache classCache;
    private AndroidTranslator androidTranslator;

    public RobolectricClassLoader(ClassHandler classHandler) {
        this(classHandler, null);
    }

    public RobolectricClassLoader(ClassHandler classHandler, List<String> customClassNames) {
        super(RobolectricClassLoader.class.getClassLoader(), null);
        this.delegateLoadingOf(AndroidTranslator.class.getName());
        this.delegateLoadingOf(ClassHandler.class.getName());
        String classCachePath = System.getProperty("cached.roboelectric.classes.path");
        File classCacheDirectory = null == classCachePath || "".equals(classCachePath.trim()) ? new File("./tmp") : new File(classCachePath);
        this.classCache = new ClassCache(new File(classCacheDirectory, "cached-robolectric-classes.jar").getAbsolutePath(), 20);
        try {
            ClassPool classPool = new ClassPool();
            classPool.appendClassPath((ClassPath)new LoaderClassPath(RobolectricClassLoader.class.getClassLoader()));
            this.androidTranslator = new AndroidTranslator(classHandler, this.classCache, customClassNames);
            this.addTranslator(classPool, this.androidTranslator);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (CannotCompileException e) {
            throw new RuntimeException(e);
        }
    }

    public void addCustomShadowClass(String classOrPackageToBeInstrumented) {
        this.androidTranslator.addCustomShadowClass(classOrPackageToBeInstrumented);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        boolean shouldComeFromThisClassLoader = !name.startsWith("org.junit") && !name.startsWith("org.hamcrest") && !name.startsWith("org.specs2") && !name.startsWith("scala.");
        Class<?> theClass = shouldComeFromThisClassLoader ? super.loadClass(name) : this.getParent().loadClass(name);
        return theClass;
    }

    public Class<?> bootstrap(Class testClass) {
        String testClassName = testClass.getName();
        try {
            return this.loadClass(testClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        byte[] classBytes = this.classCache.getClassBytesFor(name);
        if (classBytes != null) {
            return this.defineClass(name, classBytes, 0, classBytes.length);
        }
        return super.findClass(name);
    }
}

