/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.bytecode;

import com.xtremelabs.robolectric.RobolectricConfig;
import com.xtremelabs.robolectric.bytecode.ClassHandler;
import com.xtremelabs.robolectric.bytecode.RobolectricInternals;
import com.xtremelabs.robolectric.bytecode.Type;
import com.xtremelabs.robolectric.internal.RealObject;
import com.xtremelabs.robolectric.util.I18nException;
import com.xtremelabs.robolectric.util.Join;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtField;
import javassist.NotFoundException;

public class ShadowWrangler
implements ClassHandler {
    public static final String SHADOW_FIELD_NAME = "__shadow__";
    private static ShadowWrangler singleton;
    public boolean debug = false;
    private boolean strictI18n = false;
    private final Map<Class, MetaShadow> metaShadowMap = new HashMap<Class, MetaShadow>();
    private Map<String, String> shadowClassMap = new HashMap<String, String>();
    private Map<Class, Field> shadowFieldMap = new HashMap<Class, Field>();
    private boolean logMissingShadowMethods = false;

    public static ShadowWrangler getInstance() {
        if (singleton == null) {
            singleton = new ShadowWrangler();
        }
        return singleton;
    }

    private ShadowWrangler() {
    }

    @Override
    public void configure(RobolectricConfig robolectricConfig) {
        this.strictI18n = robolectricConfig.getStrictI18n();
    }

    @Override
    public void instrument(CtClass ctClass) {
        try {
            CtClass objectClass = ctClass.getClassPool().get(Object.class.getName());
            try {
                ctClass.getField(SHADOW_FIELD_NAME);
            }
            catch (NotFoundException e) {
                CtField field = new CtField(objectClass, SHADOW_FIELD_NAME, ctClass);
                field.setModifiers(1);
                ctClass.addField(field);
            }
        }
        catch (CannotCompileException e) {
            throw new RuntimeException(e);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void beforeTest() {
        this.shadowClassMap.clear();
    }

    @Override
    public void afterTest() {
    }

    public void bindShadowClass(Class<?> realClass, Class<?> shadowClass) {
        this.shadowClassMap.put(realClass.getName(), shadowClass.getName());
        if (this.debug) {
            System.out.println("shadow " + realClass + " with " + shadowClass);
        }
    }

    @Override
    public Object methodInvoked(Class clazz, String methodName, Object instance, String[] paramTypes, Object[] params) throws Throwable {
        InvocationPlan invocationPlan = new InvocationPlan(clazz, methodName, instance, paramTypes);
        if (!invocationPlan.prepare()) {
            this.reportNoShadowMethodFound(clazz, methodName, paramTypes);
            return null;
        }
        if (this.strictI18n && !invocationPlan.isI18nSafe()) {
            throw new I18nException("Method " + methodName + " on class " + clazz.getName() + " is not i18n-safe.");
        }
        try {
            return invocationPlan.getMethod().invoke(invocationPlan.getShadow(), params);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(invocationPlan.getShadow().getClass().getName() + " is not assignable from " + invocationPlan.getDeclaredShadowClass().getName(), e);
        }
        catch (InvocationTargetException e) {
            throw this.stripStackTrace(e.getCause());
        }
    }

    private <T extends Throwable> T stripStackTrace(T throwable) {
        ArrayList<StackTraceElement> stackTrace = new ArrayList<StackTraceElement>();
        for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
            boolean isInternalCall;
            String className = stackTraceElement.getClassName();
            boolean bl = isInternalCall = className.startsWith("sun.reflect.") || className.startsWith("java.lang.reflect.") || className.equals(ShadowWrangler.class.getName()) || className.equals(RobolectricInternals.class.getName());
            if (isInternalCall) continue;
            stackTrace.add(stackTraceElement);
        }
        throwable.setStackTrace(stackTrace.toArray(new StackTraceElement[stackTrace.size()]));
        return throwable;
    }

    private void reportNoShadowMethodFound(Class clazz, String methodName, String[] paramTypes) {
        if (this.logMissingShadowMethods) {
            System.out.println("No Shadow method found for " + clazz.getSimpleName() + "." + methodName + "(" + Join.join(", ", paramTypes) + ")");
        }
    }

    public static Class<?> loadClass(String paramType, ClassLoader classLoader) {
        Class primitiveClass = Type.findPrimitiveClass(paramType);
        if (primitiveClass != null) {
            return primitiveClass;
        }
        int arrayLevel = 0;
        while (paramType.endsWith("[]")) {
            ++arrayLevel;
            paramType = paramType.substring(0, paramType.length() - 2);
        }
        Class<?> clazz = Type.findPrimitiveClass(paramType);
        if (clazz == null) {
            try {
                clazz = classLoader.loadClass(paramType);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        while (arrayLevel-- > 0) {
            clazz = Array.newInstance(clazz, 0).getClass();
        }
        return clazz;
    }

    public Object shadowFor(Object instance) {
        Field field = this.getShadowField(instance);
        Object shadow = this.readField(instance, field);
        if (shadow != null) {
            return shadow;
        }
        String shadowClassName = this.getShadowClassName(instance.getClass());
        if (this.debug) {
            System.out.println("creating new " + shadowClassName + " as shadow for " + instance.getClass().getName());
        }
        try {
            Class<?> shadowClass = ShadowWrangler.loadClass(shadowClassName, instance.getClass().getClassLoader());
            Constructor<?> constructor = this.findConstructor(instance, shadowClass);
            shadow = constructor != null ? constructor.newInstance(instance) : shadowClass.newInstance();
            field.set(instance, shadow);
            this.injectRealObjectOn(shadow, shadowClass, instance);
            return shadow;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private void injectRealObjectOn(Object shadow, Class<?> shadowClass, Object instance) {
        MetaShadow metaShadow = this.getMetaShadow(shadowClass);
        for (Field realObjectField : metaShadow.realObjectFields) {
            this.writeField(shadow, instance, realObjectField);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetaShadow getMetaShadow(Class<?> shadowClass) {
        Map<Class, MetaShadow> map = this.metaShadowMap;
        synchronized (map) {
            MetaShadow metaShadow = this.metaShadowMap.get(shadowClass);
            if (metaShadow == null) {
                metaShadow = new MetaShadow(shadowClass);
                this.metaShadowMap.put(shadowClass, metaShadow);
            }
            return metaShadow;
        }
    }

    private String getShadowClassName(Class clazz) {
        String shadowClassName = null;
        while (shadowClassName == null && clazz != null) {
            shadowClassName = this.shadowClassMap.get(clazz.getName());
            clazz = clazz.getSuperclass();
        }
        return shadowClassName;
    }

    private Constructor<?> findConstructor(Object instance, Class<?> shadowClass) {
        Constructor<?> constructor = null;
        for (Class<?> clazz = instance.getClass(); constructor == null && clazz != null; clazz = clazz.getSuperclass()) {
            try {
                constructor = shadowClass.getConstructor(clazz);
                continue;
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        return constructor;
    }

    private Field getShadowField(Object instance) {
        Class<?> clazz = instance.getClass();
        Field field = this.shadowFieldMap.get(clazz);
        if (field == null) {
            try {
                field = clazz.getField(SHADOW_FIELD_NAME);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(instance.getClass().getName() + " has no shadow field", e);
            }
            this.shadowFieldMap.put(clazz, field);
        }
        return field;
    }

    public Object shadowOf(Object instance) {
        if (instance == null) {
            throw new NullPointerException("can't get a shadow for null");
        }
        Field field = this.getShadowField(instance);
        return this.readField(instance, field);
    }

    private Object readField(Object target, Field field) {
        try {
            return field.get(target);
        }
        catch (IllegalAccessException e1) {
            throw new RuntimeException(e1);
        }
    }

    private void writeField(Object target, Object value, Field realObjectField) {
        try {
            realObjectField.set(target, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void logMissingInvokedShadowMethods() {
        this.logMissingShadowMethods = true;
    }

    public void silence() {
        this.logMissingShadowMethods = false;
    }

    private class MetaShadow {
        List<Field> realObjectFields = new ArrayList<Field>();

        public MetaShadow(Class<?> shadowClass) {
            while (shadowClass != null) {
                for (Field field : shadowClass.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(RealObject.class)) continue;
                    field.setAccessible(true);
                    this.realObjectFields.add(field);
                }
                shadowClass = shadowClass.getSuperclass();
            }
        }
    }

    private class InvocationPlan {
        private Class clazz;
        private ClassLoader classLoader;
        private String methodName;
        private Object instance;
        private String[] paramTypes;
        private Class<?> declaredShadowClass;
        private Method method;
        private Object shadow;

        public InvocationPlan(Class clazz, String methodName, Object instance, String ... paramTypes) {
            this.clazz = clazz;
            this.classLoader = clazz.getClassLoader();
            this.methodName = methodName;
            this.instance = instance;
            this.paramTypes = paramTypes;
        }

        public Class<?> getDeclaredShadowClass() {
            return this.declaredShadowClass;
        }

        public Method getMethod() {
            return this.method;
        }

        public Object getShadow() {
            return this.shadow;
        }

        public boolean isI18nSafe() {
            Annotation[] annos = this.method.getAnnotations();
            for (int i = 0; i < annos.length; ++i) {
                String name = annos[i].annotationType().getName();
                if (!name.equals("com.xtremelabs.robolectric.internal.Implementation")) continue;
                try {
                    Method m = annos[i].getClass().getMethod("i18nSafe", new Class[0]);
                    return (Boolean)m.invoke((Object)annos[i], new Object[0]);
                }
                catch (Exception e) {
                    return true;
                }
            }
            return true;
        }

        public boolean prepare() {
            Class<?>[] paramClasses = this.getParamClasses();
            Class<?> originalClass = ShadowWrangler.loadClass(this.clazz.getName(), this.classLoader);
            this.declaredShadowClass = this.findDeclaredShadowClassForMethod(originalClass, this.methodName, paramClasses);
            if (this.declaredShadowClass == null) {
                return false;
            }
            if (this.methodName.equals("<init>")) {
                this.methodName = "__constructor__";
            }
            if (this.instance != null) {
                this.shadow = ShadowWrangler.this.shadowFor(this.instance);
                this.method = this.getMethod(this.shadow.getClass(), this.methodName, paramClasses);
            } else {
                this.shadow = null;
                this.method = this.getMethod(this.findShadowClass(this.clazz), this.methodName, paramClasses);
            }
            if (this.method == null) {
                if (ShadowWrangler.this.debug) {
                    System.out.println("No method found for " + this.clazz + "." + this.methodName + "(" + Arrays.asList(paramClasses) + ") on " + this.declaredShadowClass.getName());
                }
                return false;
            }
            if (this.instance == null != Modifier.isStatic(this.method.getModifiers())) {
                throw new RuntimeException("method staticness of " + this.clazz.getName() + "." + this.methodName + " and " + this.declaredShadowClass.getName() + "." + this.method.getName() + " don't match");
            }
            this.method.setAccessible(true);
            return true;
        }

        private Class<?> findDeclaredShadowClassForMethod(Class<?> originalClass, String methodName, Class<?>[] paramClasses) {
            Class<?> declaringClass = this.findDeclaringClassForMethod(methodName, paramClasses, originalClass);
            return this.findShadowClass(declaringClass);
        }

        private Class<?> findShadowClass(Class<?> originalClass) {
            String declaredShadowClassName = ShadowWrangler.this.getShadowClassName(originalClass);
            if (declaredShadowClassName == null) {
                return null;
            }
            return ShadowWrangler.loadClass(declaredShadowClassName, this.classLoader);
        }

        private Class<?> findDeclaringClassForMethod(String methodName, Class<?>[] paramClasses, Class<?> originalClass) {
            Class<?> declaringClass;
            if (this.methodName.equals("<init>")) {
                declaringClass = originalClass;
            } else {
                Method originalMethod;
                try {
                    originalMethod = originalClass.getDeclaredMethod(methodName, paramClasses);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
                declaringClass = originalMethod.getDeclaringClass();
            }
            return declaringClass;
        }

        private Class<?>[] getParamClasses() {
            Class[] paramClasses = new Class[this.paramTypes.length];
            for (int i = 0; i < this.paramTypes.length; ++i) {
                paramClasses[i] = ShadowWrangler.loadClass(this.paramTypes[i], this.classLoader);
            }
            return paramClasses;
        }

        private Method getMethod(Class<?> clazz, String methodName, Class<?>[] paramClasses) {
            Method method = null;
            try {
                method = clazz.getMethod(methodName, paramClasses);
            }
            catch (NoSuchMethodException e) {
                try {
                    method = clazz.getDeclaredMethod(methodName, paramClasses);
                }
                catch (NoSuchMethodException e1) {
                    method = null;
                }
            }
            if (method != null && !this.isOnShadowClass(method)) {
                method = null;
            }
            return method;
        }

        private boolean isOnShadowClass(Method method) {
            Class<?> declaringClass = method.getDeclaringClass();
            for (Annotation annotation : declaringClass.getAnnotations()) {
                if (!annotation.annotationType().toString().equals("interface com.xtremelabs.robolectric.internal.Implements")) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return "delegating to " + this.declaredShadowClass.getName() + "." + this.method.getName() + "(" + Arrays.toString(this.method.getParameterTypes()) + ")";
        }
    }
}

