/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.internal;

public class ClassNameResolver<T> {
    private String packageName;
    private String className;

    public ClassNameResolver(String packageName, String className) {
        this.packageName = packageName;
        this.className = className;
    }

    public Class<? extends T> resolve() {
        Class<T> aClass;
        if (this.looksFullyQualified(this.className)) {
            aClass = this.safeClassForName(this.className);
        } else {
            aClass = this.safeClassForName(this.packageName + "." + this.className);
            if (aClass == null) {
                aClass = this.safeClassForName(this.packageName + this.className);
            }
        }
        if (aClass == null) {
            throw new RuntimeException("Could not find a class for package: " + this.packageName + " and class name: " + this.className);
        }
        return aClass;
    }

    private boolean looksFullyQualified(String className) {
        return className.contains(".") && !className.startsWith(".");
    }

    private Class<? extends T> safeClassForName(String classNamePath) {
        try {
            return Class.forName(classNamePath);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

