/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.matchers;

import android.widget.CompoundButton;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class CompoundButtonCheckedMatcher<T extends CompoundButton>
extends TypeSafeMatcher<T> {
    private boolean expected;

    public CompoundButtonCheckedMatcher(boolean expected) {
        this.expected = expected;
    }

    protected boolean matchesSafely(T compoundButton) {
        return compoundButton != null && this.expected == compoundButton.isChecked();
    }

    public void describeTo(Description description) {
        description.appendText("to be [" + (this.expected ? "checked" : "unchecked") + "]");
    }

    @Factory
    public static <T extends CompoundButton> Matcher<T> isChecked(boolean expectedChecked) {
        return new CompoundButtonCheckedMatcher<T>(expectedChecked);
    }
}

