/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.matchers;

import android.widget.TextView;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.shadows.ShadowTextView;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.junit.internal.matchers.TypeSafeMatcher;

public class HasCompoundDrawablesMatcher
extends TypeSafeMatcher<TextView> {
    private String message;
    private ShadowTextView.CompoundDrawables expectedCompoundDrawables;

    public HasCompoundDrawablesMatcher(int left, int top, int right, int bottom) {
        this.expectedCompoundDrawables = new ShadowTextView.CompoundDrawables(left, top, right, bottom);
    }

    public boolean matchesSafely(TextView actual) {
        if (actual == null) {
            this.message = "actual view was null";
            return false;
        }
        ShadowTextView.CompoundDrawables actualCompoundDrawables = Robolectric.shadowOf(actual).getCompoundDrawablesImpl();
        if (!this.expectedCompoundDrawables.equals(actualCompoundDrawables)) {
            this.message = "[" + actualCompoundDrawables + "] to equal [" + this.expectedCompoundDrawables + "]";
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText(this.message);
    }

    @Factory
    public static Matcher<TextView> hasCompoundDrawables(int left, int top, int right, int bottom) {
        return new HasCompoundDrawablesMatcher(left, top, right, bottom);
    }
}

