/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.matchers;

import android.widget.ImageView;
import com.xtremelabs.robolectric.Robolectric;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.junit.internal.matchers.TypeSafeMatcher;

public class HasResourceMatcher
extends TypeSafeMatcher<ImageView> {
    private int expectedResourceId;
    private Integer actualResourceId;

    public HasResourceMatcher(int expectedResourceId) {
        this.expectedResourceId = expectedResourceId;
    }

    public boolean matchesSafely(ImageView actual) {
        if (actual == null) {
            return false;
        }
        this.actualResourceId = Robolectric.shadowOf(actual).getResourceId();
        return this.actualResourceId == this.expectedResourceId;
    }

    public void describeTo(Description description) {
        if (this.actualResourceId == null) {
            description.appendText("actual view was null");
        } else {
            description.appendText("[" + this.actualResourceId + "]");
            description.appendText(" to equal ");
            description.appendText("[" + this.expectedResourceId + "]");
        }
    }

    @Factory
    public static Matcher<ImageView> hasResource(int expectedResourceId) {
        return new HasResourceMatcher(expectedResourceId);
    }
}

