/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.matchers;

import android.widget.ImageView;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.res.ResourceLoader;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.junit.internal.matchers.TypeSafeMatcher;

public class ImageViewHasDrawableMatcher<T extends ImageView>
extends TypeSafeMatcher<T> {
    private int expectedResourceId;
    private String message;

    public ImageViewHasDrawableMatcher(int expectedResourceId) {
        this.expectedResourceId = expectedResourceId;
    }

    public boolean matchesSafely(T actualImageView) {
        if (actualImageView == null) {
            return false;
        }
        ResourceLoader resourceLoader = ResourceLoader.getFrom(actualImageView.getContext());
        int actualResourceId = Robolectric.shadowOf(actualImageView).getResourceId();
        String actualName = this.nameOrUnset(resourceLoader, actualResourceId);
        String expectedName = this.nameOrUnset(resourceLoader, this.expectedResourceId);
        this.message = "[" + actualResourceId + " (" + actualName + ")] to equal [" + this.expectedResourceId + " (" + expectedName + ")]";
        return actualResourceId == this.expectedResourceId;
    }

    private String nameOrUnset(ResourceLoader resourceLoader, int resourceId) {
        return resourceId == 0 ? "unset" : resourceLoader.getNameForId(resourceId);
    }

    public void describeTo(Description description) {
        description.appendText(this.message);
    }

    @Factory
    public static <T extends ImageView> Matcher<T> hasDrawable(int expectedResourceId) {
        return new ImageViewHasDrawableMatcher<T>(expectedResourceId);
    }
}

