/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.matchers;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.shadows.ShadowIntent;
import org.hamcrest.Description;
import org.junit.internal.matchers.TypeSafeMatcher;

public class StartedMatcher
extends TypeSafeMatcher<Context> {
    private final Intent expectedIntent;
    private String message;

    public StartedMatcher(Intent expectedIntent) {
        this.expectedIntent = expectedIntent;
    }

    public StartedMatcher(String packageName, Class<? extends Activity> expectedActivityClass) {
        this(StartedMatcher.createIntent(packageName, expectedActivityClass));
    }

    public StartedMatcher(Class<? extends Activity> expectedActivityClass) {
        this(StartedMatcher.createIntent(expectedActivityClass));
    }

    public StartedMatcher(Class<? extends Activity> expectedActivityClass, String expectedAction) {
        this(StartedMatcher.createIntent(expectedActivityClass));
        this.expectedIntent.setAction(expectedAction);
    }

    public boolean matchesSafely(Context actualContext) {
        if (this.expectedIntent == null) {
            this.message = "null intent (did you mean to expect null?)";
            return false;
        }
        String expected = this.expectedIntent.toString();
        this.message = "to start " + expected + ", but ";
        Intent actualStartedIntent = Robolectric.shadowOf((ContextWrapper)actualContext).getNextStartedActivity();
        if (actualStartedIntent == null) {
            this.message = this.message + "didn't start anything";
            return false;
        }
        ShadowIntent shadowIntent = Robolectric.shadowOf(actualStartedIntent);
        boolean intentsMatch = Robolectric.shadowOf(this.expectedIntent).realIntentEquals(shadowIntent);
        if (!intentsMatch) {
            this.message = this.message + "started " + actualStartedIntent;
        }
        return intentsMatch;
    }

    public void describeTo(Description description) {
        description.appendText(this.message);
    }

    public static Intent createIntent(Class<? extends Activity> activityClass, String extraKey, String extraValue) {
        Intent intent = StartedMatcher.createIntent(activityClass);
        intent.putExtra(extraKey, extraValue);
        return intent;
    }

    public static Intent createIntent(Class<? extends Activity> activityClass, String action) {
        Intent intent = StartedMatcher.createIntent(activityClass);
        intent.setAction(action);
        return intent;
    }

    public static Intent createIntent(Class<? extends Activity> activityClass) {
        String packageName = activityClass.getPackage().getName();
        return StartedMatcher.createIntent(packageName, activityClass);
    }

    public static Intent createIntent(String packageName, Class<? extends Activity> activityClass) {
        Intent intent = new Intent();
        intent.setClassName(packageName, activityClass.getName());
        return intent;
    }
}

