/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.matchers;

import android.app.Service;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.shadows.ShadowIntent;
import java.util.Set;
import org.hamcrest.Description;
import org.junit.internal.matchers.TypeSafeMatcher;

public class StartedServiceMatcher
extends TypeSafeMatcher<Context> {
    private final Intent expectedIntent;
    private String message;

    public StartedServiceMatcher(Intent expectedIntent) {
        this.expectedIntent = expectedIntent;
    }

    public StartedServiceMatcher(String packageName, Class<? extends Service> expectedServiceClass) {
        this(StartedServiceMatcher.createIntent(packageName, expectedServiceClass));
    }

    public StartedServiceMatcher(Class<? extends Service> expectedServiceClass) {
        this(StartedServiceMatcher.createIntent(expectedServiceClass));
    }

    public StartedServiceMatcher(Class<? extends Service> expectedServiceClass, String expectedAction) {
        this(StartedServiceMatcher.createIntent(expectedServiceClass));
        this.expectedIntent.setAction(expectedAction);
    }

    public boolean matchesSafely(Context actualContext) {
        if (this.expectedIntent == null) {
            this.message = "null intent (did you mean to expect null?)";
            return false;
        }
        String expected = this.expectedIntent.toString();
        this.message = "to start " + expected + ", but ";
        Intent actualStartedIntent = Robolectric.shadowOf((ContextWrapper)actualContext).getNextStartedService();
        if (actualStartedIntent == null) {
            this.message = this.message + "didn't start anything";
            return false;
        }
        ShadowIntent shadowIntent = Robolectric.shadowOf(actualStartedIntent);
        boolean intentsMatch = Robolectric.shadowOf(this.expectedIntent).getIntentClass().equals(shadowIntent.getIntentClass());
        if (!intentsMatch) {
            this.message = this.message + "started " + actualStartedIntent;
        } else {
            Set expectedKeys;
            Set keys = shadowIntent.getExtras().keySet();
            intentsMatch = ((Object)keys).equals(expectedKeys = Robolectric.shadowOf(this.expectedIntent).getExtras().keySet());
            if (!intentsMatch) {
                this.message = this.message + "did not get the same extras keys";
            }
        }
        return intentsMatch;
    }

    public void describeTo(Description description) {
        description.appendText(this.message);
    }

    public static Intent createIntent(Class<? extends Service> serviceClass, String extraKey, String extraValue) {
        Intent intent = StartedServiceMatcher.createIntent(serviceClass);
        intent.putExtra(extraKey, extraValue);
        return intent;
    }

    public static Intent createIntent(Class<? extends Service> serviceClass, String action) {
        Intent intent = StartedServiceMatcher.createIntent(serviceClass);
        intent.setAction(action);
        return intent;
    }

    public static Intent createIntent(Class<? extends Service> serviceClass) {
        Package pack = serviceClass.getPackage();
        String packageName = "android.service";
        if (pack != null) {
            pack.getName();
        }
        return StartedServiceMatcher.createIntent(packageName, serviceClass);
    }

    public static Intent createIntent(String packageName, Class<? extends Service> serviceClass) {
        Intent intent = new Intent();
        intent.setClassName(packageName, serviceClass.getName());
        intent.setClass(Robolectric.getShadowApplication().getApplicationContext(), serviceClass);
        return intent;
    }
}

