/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.matchers;

import android.widget.TextView;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.junit.internal.matchers.TypeSafeMatcher;

public class TextViewHasTextMatcher<T extends TextView>
extends TypeSafeMatcher<T> {
    private String expected;
    private String actualText;

    public TextViewHasTextMatcher(String expected) {
        this.expected = expected;
    }

    public boolean matchesSafely(T actual) {
        if (actual == null) {
            return false;
        }
        CharSequence charSequence = actual.getText();
        if (charSequence == null || ((Object)charSequence).toString() == null) {
            return false;
        }
        this.actualText = ((Object)charSequence).toString();
        return this.actualText.equals(this.expected);
    }

    public void describeTo(Description description) {
        description.appendText("[" + this.actualText + "]");
        description.appendText(" to equal ");
        description.appendText("[" + this.expected + "]");
    }

    @Factory
    public static <T extends TextView> Matcher<T> hasText(String expectedTextViewText) {
        return new TextViewHasTextMatcher<T>(expectedTextViewText);
    }
}

