/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.matchers;

import android.view.View;
import com.xtremelabs.robolectric.Robolectric;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.junit.internal.matchers.TypeSafeMatcher;

public class ViewHasTextMatcher<T extends View>
extends TypeSafeMatcher<T> {
    private String expected;
    private int expectedResourceId;
    private String actualText;

    public ViewHasTextMatcher(String expected) {
        this.expected = expected;
        this.expectedResourceId = -1;
    }

    public ViewHasTextMatcher(int expectedResourceId) {
        this.expected = null;
        this.expectedResourceId = expectedResourceId;
    }

    public boolean matchesSafely(View actual) {
        String charSequence;
        if (actual == null) {
            return false;
        }
        if (this.expectedResourceId != -1) {
            this.expected = actual.getContext().getResources().getString(this.expectedResourceId);
        }
        if ((charSequence = Robolectric.shadowOf(actual).innerText()) == null || charSequence.toString() == null) {
            return false;
        }
        this.actualText = charSequence.toString();
        return this.actualText.equals(this.expected);
    }

    public void describeTo(Description description) {
        description.appendText("[" + this.actualText + "]");
        description.appendText(" to equal ");
        description.appendText("[" + this.expected + "]");
    }

    @Factory
    public static <T extends View> Matcher<T> hasText(String expectedTextViewText) {
        return new ViewHasTextMatcher<T>(expectedTextViewText);
    }

    @Factory
    public static <T extends View> Matcher<T> hasText(int expectedTextViewResourceId) {
        return new ViewHasTextMatcher<T>(expectedTextViewResourceId);
    }
}

