/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.res;

import com.xtremelabs.robolectric.res.ResourceExtractor;
import com.xtremelabs.robolectric.res.ResourceReferenceResolver;
import com.xtremelabs.robolectric.res.ResourceValueConverter;
import com.xtremelabs.robolectric.res.XpathResourceXmlLoader;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Node;

public class ColorResourceLoader
extends XpathResourceXmlLoader
implements ResourceValueConverter {
    private ResourceReferenceResolver<Integer> colorResolver = new ResourceReferenceResolver("color");
    private static Map<String, Integer> androidColors = new HashMap<String, Integer>();

    public ColorResourceLoader(ResourceExtractor resourceExtractor) {
        super(resourceExtractor, "/resources/color");
    }

    public int getValue(int colorId) {
        String resourceName = this.resourceExtractor.getResourceName(colorId);
        return resourceName == null ? -1 : this.colorResolver.getValue(resourceName);
    }

    @Override
    protected void processNode(Node node, String name, boolean isSystem) {
        this.colorResolver.processResource(name, node.getTextContent(), this, isSystem);
    }

    @Override
    public Integer convertRawValue(String rawValue) {
        if (rawValue.startsWith("#")) {
            long color = Long.parseLong(rawValue.substring(1), 16);
            return (int)color;
        }
        if (androidColors.containsKey(rawValue)) {
            return androidColors.get(rawValue);
        }
        return null;
    }

    static {
        androidColors.put("black", -16777216);
        androidColors.put("darkgray", -12303292);
        androidColors.put("gray", -7829368);
        androidColors.put("lightgray", -3355444);
        androidColors.put("white", -1);
        androidColors.put("red", -65536);
        androidColors.put("green", -16711936);
        androidColors.put("blue", -16776961);
        androidColors.put("yellow", -256);
        androidColors.put("cyan", -16711681);
        androidColors.put("magenta", -65281);
    }
}

