/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.res;

import com.xtremelabs.robolectric.res.ResourceExtractor;
import com.xtremelabs.robolectric.res.ResourceReferenceResolver;
import com.xtremelabs.robolectric.res.ResourceValueConverter;
import com.xtremelabs.robolectric.res.XpathResourceXmlLoader;
import org.w3c.dom.Node;

public class DimenResourceLoader
extends XpathResourceXmlLoader
implements ResourceValueConverter {
    private static final String[] UNITS = new String[]{"dp", "dip", "px", "sp"};
    private ResourceReferenceResolver<Float> dimenResolver = new ResourceReferenceResolver("dimen");

    public DimenResourceLoader(ResourceExtractor resourceExtractor) {
        super(resourceExtractor, "/resources/dimen");
    }

    public float getValue(int resourceId) {
        return this.dimenResolver.getValue(this.resourceExtractor.getResourceName(resourceId)).floatValue();
    }

    public float getValue(String resourceName, boolean isSystem) {
        return this.getValue(this.resourceExtractor.getResourceId(resourceName, isSystem));
    }

    @Override
    protected void processNode(Node node, String name, boolean isSystem) {
        this.dimenResolver.processResource(name, node.getTextContent(), this, isSystem);
    }

    @Override
    public Object convertRawValue(String rawValue) {
        int end = rawValue.length();
        for (int i = 0; i < UNITS.length; ++i) {
            int index = rawValue.indexOf(UNITS[i]);
            if (index < 0 || end <= index) continue;
            end = index;
        }
        return Float.valueOf(Float.parseFloat(rawValue.substring(0, end)));
    }
}

