/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.res;

import com.xtremelabs.robolectric.res.XmlLoader;
import java.io.File;
import java.io.FileFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class DocumentLoader {
    private final XmlLoader[] xmlLoaders;
    private final DocumentBuilderFactory documentBuilderFactory;
    private FileFilter xmlFileFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.getName().endsWith(".xml");
        }
    };

    public DocumentLoader(XmlLoader ... xmlLoaders) {
        this.xmlLoaders = xmlLoaders;
        this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.documentBuilderFactory.setNamespaceAware(true);
        this.documentBuilderFactory.setIgnoringComments(true);
        this.documentBuilderFactory.setIgnoringElementContentWhitespace(true);
    }

    public void loadResourceXmlDirs(File ... resourceXmlDirs) throws Exception {
        this.loadResourceXmlDirs(false, resourceXmlDirs);
    }

    public void loadResourceXmlDirs(boolean isSystem, File ... resourceXmlDirs) throws Exception {
        for (File resourceXmlDir : resourceXmlDirs) {
            this.loadResourceXmlDir(resourceXmlDir, isSystem);
        }
    }

    public void loadResourceXmlDir(File resourceXmlDir) throws Exception {
        this.loadResourceXmlDir(resourceXmlDir, false);
    }

    public void loadSystemResourceXmlDir(File resourceXmlDir) throws Exception {
        this.loadResourceXmlDir(resourceXmlDir, true);
    }

    private void loadResourceXmlDir(File resourceXmlDir, boolean isSystem) throws Exception {
        if (!resourceXmlDir.exists()) {
            throw new RuntimeException("no such directory " + resourceXmlDir);
        }
        for (File file : resourceXmlDir.listFiles(this.xmlFileFilter)) {
            this.loadResourceXmlFile(file, isSystem);
        }
    }

    private void loadResourceXmlFile(File file, boolean isSystem) throws Exception {
        for (XmlLoader xmlLoader : this.xmlLoaders) {
            xmlLoader.processResourceXml(file, this.parse(file), isSystem);
        }
    }

    private Document parse(File xmlFile) throws Exception {
        DocumentBuilder documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.parse(xmlFile);
    }
}

