/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.res;

import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.StateListDrawable;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.res.ResourceExtractor;
import com.xtremelabs.robolectric.res.XmlLoader;
import com.xtremelabs.robolectric.shadows.ShadowStateListDrawable;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DrawableResourceLoader
extends XmlLoader {
    private static final Map<String, Integer> stateMap = new HashMap<String, Integer>();
    protected Map<String, Document> documents = new HashMap<String, Document>();
    protected File resourceDirectory;

    public DrawableResourceLoader(ResourceExtractor extractor, File resourceDirectory) {
        super(extractor);
        this.resourceDirectory = resourceDirectory;
    }

    public boolean isXml(int resourceId) {
        return this.documents.containsKey(this.resourceExtractor.getResourceName(resourceId));
    }

    public Drawable getXmlDrawable(int resId) {
        if (!this.isXml(resId)) {
            return null;
        }
        Document xmlDoc = this.documents.get(this.resourceExtractor.getResourceName(resId));
        NodeList nodes = xmlDoc.getElementsByTagName("selector");
        if (nodes != null && nodes.getLength() > 0) {
            return this.buildStateListDrawable(xmlDoc);
        }
        nodes = xmlDoc.getElementsByTagName("layer-list");
        if (nodes != null && nodes.getLength() > 0) {
            return new LayerDrawable(null);
        }
        nodes = xmlDoc.getElementsByTagName("animation-list");
        if (nodes != null && nodes.getLength() > 0) {
            return new AnimationDrawable();
        }
        return null;
    }

    @Override
    protected void processResourceXml(File xmlFile, Document document, boolean isSystem) throws Exception {
        String name = this.toResourceName(xmlFile);
        if (!this.documents.containsKey(name)) {
            if (isSystem) {
                name = "android:" + name;
            }
            this.documents.put(name, document);
        }
    }

    private String toResourceName(File xmlFile) {
        try {
            return xmlFile.getCanonicalPath().replaceAll("[/\\\\\\\\]", "/").replaceAll("^.*?/res/", "").replaceAll("\\..+$", "");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected int[] getDrawableIds(int resourceId) {
        String resourceName = this.resourceExtractor.getResourceName(resourceId);
        Document document = this.documents.get(resourceName);
        NodeList items = document.getElementsByTagName("item");
        int[] drawableIds = new int[items.getLength()];
        for (int i = 0; i < items.getLength(); ++i) {
            if (resourceName.startsWith("android:")) {
                drawableIds[i] = -1;
                continue;
            }
            Node item = items.item(i);
            Node drawableName = item.getAttributes().getNamedItem("android:drawable");
            if (drawableName == null) continue;
            drawableIds[i] = this.resourceExtractor.getResourceId(drawableName.getNodeValue());
        }
        return drawableIds;
    }

    public boolean isAnimationDrawable(int resourceId) {
        Document document = this.documents.get(this.resourceExtractor.getResourceName(resourceId));
        return "animation-list".equals(document.getDocumentElement().getLocalName());
    }

    private StateListDrawable buildStateListDrawable(Document d) {
        StateListDrawable drawable = new StateListDrawable();
        ShadowStateListDrawable shDrawable = Robolectric.shadowOf(drawable);
        NodeList items = d.getElementsByTagName("item");
        for (int i = 0; i < items.getLength(); ++i) {
            Node node = items.item(i);
            Node drawableName = node.getAttributes().getNamedItem("android:drawable");
            if (drawableName == null) continue;
            int resId = this.resourceExtractor.getResourceId(drawableName.getNodeValue());
            int stateId = this.getStateId(node);
            shDrawable.addState(stateId, resId);
        }
        return drawable;
    }

    private int getStateId(Node node) {
        NamedNodeMap attrs = node.getAttributes();
        for (String state : stateMap.keySet()) {
            Node attr = attrs.getNamedItem(state);
            if (attr == null) continue;
            return stateMap.get(state);
        }
        return 16842914;
    }

    static {
        stateMap.put("android:state_selected", 0x10100A1);
        stateMap.put("android:state_pressed", 16842919);
        stateMap.put("android:state_focused", 16842908);
        stateMap.put("android:state_checkable", 16842911);
        stateMap.put("android:state_checked", 0x10100A0);
        stateMap.put("android:state_enabled", 16842910);
        stateMap.put("android:state_window_focused", 16842909);
    }
}

