/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.res;

import com.xtremelabs.robolectric.res.ResourceExtractor;
import com.xtremelabs.robolectric.res.ResourceReferenceResolver;
import com.xtremelabs.robolectric.res.ResourceValueConverter;
import com.xtremelabs.robolectric.res.XTagXmlResourceLoader;
import org.w3c.dom.Node;

public class IntegerResourceLoader
extends XTagXmlResourceLoader
implements ResourceValueConverter {
    private ResourceReferenceResolver<Integer> integerResolver = new ResourceReferenceResolver("integer");

    public IntegerResourceLoader(ResourceExtractor resourceExtractor) {
        super(resourceExtractor, "integer");
    }

    public int getValue(int resourceId) {
        String resourceName = this.resourceExtractor.getResourceName(resourceId);
        return this.integerResolver.getValue(resourceName);
    }

    public int getValue(String resourceName, boolean isSystem) {
        return this.getValue(this.resourceExtractor.getResourceId(resourceName, isSystem));
    }

    @Override
    public Object convertRawValue(String rawValue) {
        try {
            return Integer.parseInt(rawValue);
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException(rawValue + " is not an integer.");
        }
    }

    @Override
    protected void processNode(Node node, String name, boolean isSystem) {
        this.integerResolver.processResource(name, node.getTextContent(), this, isSystem);
    }
}

