/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.res;

import android.content.Context;
import android.text.TextUtils;
import android.view.Menu;
import android.view.MenuItem;
import android.view.SubMenu;
import com.xtremelabs.robolectric.res.AttrResourceLoader;
import com.xtremelabs.robolectric.res.ResourceExtractor;
import com.xtremelabs.robolectric.res.XmlLoader;
import com.xtremelabs.robolectric.tester.android.util.TestAttributeSet;
import com.xtremelabs.robolectric.util.I18nException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MenuLoader
extends XmlLoader {
    private Map<String, MenuNode> menuNodesByMenuName = new HashMap<String, MenuNode>();
    private AttrResourceLoader attrResourceLoader;

    public MenuLoader(ResourceExtractor resourceExtractor, AttrResourceLoader attrResourceLoader) {
        super(resourceExtractor);
        this.attrResourceLoader = attrResourceLoader;
    }

    @Override
    protected void processResourceXml(File xmlFile, Document document, boolean ignored) throws Exception {
        MenuNode topLevelNode = new MenuNode("top-level", new HashMap<String, String>());
        NodeList items = document.getChildNodes();
        if (items.getLength() != 1) {
            throw new RuntimeException("Expected only one top-level item in menu file " + xmlFile.getName());
        }
        if (items.item(0).getNodeName().compareTo("menu") != 0) {
            throw new RuntimeException("Expected a top-level item called 'menu' in menu file " + xmlFile.getName());
        }
        this.processChildren(items.item(0).getChildNodes(), topLevelNode);
        this.menuNodesByMenuName.put("menu/" + xmlFile.getName().replace(".xml", ""), topLevelNode);
    }

    private void processChildren(NodeList childNodes, MenuNode parent) {
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            this.processNode(node, parent);
        }
    }

    private void processNode(Node node, MenuNode parent) {
        String name = node.getNodeName();
        NamedNodeMap attributes = node.getAttributes();
        HashMap<String, String> attrMap = new HashMap<String, String>();
        if (attributes != null) {
            int length = attributes.getLength();
            for (int i = 0; i < length; ++i) {
                Node attr = attributes.item(i);
                attrMap.put(attr.getNodeName(), attr.getNodeValue());
            }
        }
        if (!name.startsWith("#")) {
            MenuNode menuNode = new MenuNode(name, attrMap);
            parent.addChild(menuNode);
            NodeList children = node.getChildNodes();
            if (children != null && children.getLength() != 0) {
                for (int i = 0; i < children.getLength(); ++i) {
                    Node nodei = children.item(i);
                    if (MenuLoader.childToIgnore(nodei)) continue;
                    if (MenuLoader.validChildren(nodei)) {
                        this.processNode(nodei, menuNode);
                        continue;
                    }
                    throw new RuntimeException("Unknown menu node" + nodei.getNodeName());
                }
            }
        }
    }

    private static boolean childToIgnore(Node nodei) {
        return TextUtils.isEmpty((CharSequence)nodei.getNodeName()) || nodei.getNodeName().startsWith("#");
    }

    private static boolean validChildren(Node nodei) {
        return nodei.getNodeName().equals("item") || nodei.getNodeName().equals("menu") || nodei.getNodeName().equals("group");
    }

    public void inflateMenu(Context context, String key, Menu root) {
        this.inflateMenu(context, key, null, root);
    }

    public void inflateMenu(Context context, int resourceId, Menu root) {
        this.inflateMenu(context, this.resourceExtractor.getResourceName(resourceId), root);
    }

    private void inflateMenu(Context context, String key, Map<String, String> attributes, Menu root) {
        MenuNode menuNode = this.menuNodesByMenuName.get(key);
        if (menuNode == null) {
            throw new RuntimeException("Could not find menu " + key);
        }
        try {
            if (attributes != null) {
                for (Map.Entry<String, String> entry : attributes.entrySet()) {
                    if (entry.getKey().equals("menu")) continue;
                    menuNode.attributes.put(entry.getKey(), entry.getValue());
                }
            }
            menuNode.inflate(context, root);
        }
        catch (I18nException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("error inflating " + key, e);
        }
    }

    public class MenuNode {
        private String name;
        private final TestAttributeSet attributes;
        private List<MenuNode> children = new ArrayList<MenuNode>();

        public MenuNode(String name, Map<String, String> attributes) {
            this.name = name;
            this.attributes = new TestAttributeSet(attributes, MenuLoader.this.resourceExtractor, MenuLoader.this.attrResourceLoader, null, false);
        }

        public List<MenuNode> getChildren() {
            return this.children;
        }

        public void addChild(MenuNode MenuNode2) {
            this.children.add(MenuNode2);
        }

        private boolean isSubMenuItem(MenuNode child) {
            List<MenuNode> ch = child.children;
            return ch != null && ch.size() == 1 && "menu".equals(ch.get((int)0).name);
        }

        private void addChildrenInGroup(MenuNode source, int groupId, Menu root) {
            for (MenuNode child : source.children) {
                String name = child.name;
                TestAttributeSet attributes = child.attributes;
                if (MenuLoader.this.strictI18n) {
                    attributes.validateStrictI18n();
                }
                if (name.equals("item")) {
                    if (this.isSubMenuItem(child)) {
                        SubMenu sub = root.addSubMenu(groupId, attributes.getAttributeResourceValue("android", "id", 0), 0, (CharSequence)attributes.getAttributeValue("android", "title"));
                        MenuNode subMenuNode = child.children.get(0);
                        this.addChildrenInGroup(subMenuNode, groupId, (Menu)sub);
                        continue;
                    }
                    MenuItem menuItem = root.add(groupId, attributes.getAttributeResourceValue("android", "id", 0), 0, (CharSequence)attributes.getAttributeValue("android", "title"));
                    continue;
                }
                if (!name.equals("group")) continue;
                int newGroupId = attributes.getAttributeResourceValue("android", "id", 0);
                this.addChildrenInGroup(child, newGroupId, root);
            }
        }

        public void inflate(Context context, Menu root) throws Exception {
            this.addChildrenInGroup(this, 0, root);
        }
    }
}

