/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.res;

import com.xtremelabs.robolectric.res.ResourceExtractor;
import com.xtremelabs.robolectric.res.ResourceValueConverter;
import com.xtremelabs.robolectric.res.StringResourceLoader;
import com.xtremelabs.robolectric.res.XpathResourceXmlLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PluralResourceLoader
extends XpathResourceXmlLoader
implements ResourceValueConverter {
    Map<String, PluralRules> plurals = new HashMap<String, PluralRules>();
    private StringResourceLoader stringResourceLoader;

    public PluralResourceLoader(ResourceExtractor resourceExtractor, StringResourceLoader stringResourceLoader) {
        super(resourceExtractor, "/resources/plurals");
        this.stringResourceLoader = stringResourceLoader;
    }

    public String getValue(int resourceId, int quantity) {
        Plural p;
        String name = this.resourceExtractor.getResourceName(resourceId);
        PluralRules rules = this.plurals.get(name);
        if (rules != null && (p = rules.find(quantity)) != null) {
            return p.string;
        }
        return null;
    }

    @Override
    protected void processNode(Node node, String name, boolean isSystem) throws XPathExpressionException {
        XPathExpression itemXPath = XPathFactory.newInstance().newXPath().compile("item");
        NodeList childNodes = (NodeList)itemXPath.evaluate(node, XPathConstants.NODESET);
        PluralRules rules = new PluralRules();
        for (int j = 0; j < childNodes.getLength(); ++j) {
            Node childNode = childNodes.item(j);
            String value = childNode.getTextContent();
            String quantity = childNode.getAttributes().getNamedItem("quantity").getTextContent();
            if (value.startsWith("@")) {
                value = value.substring(1);
                rules.add(new Plural(quantity, this.stringResourceLoader.getValue(value, isSystem)));
                continue;
            }
            rules.add(new Plural(quantity, value));
        }
        this.plurals.put("plurals/" + name, rules);
    }

    @Override
    public Object convertRawValue(String rawValue) {
        return rawValue;
    }

    static class Plural {
        final String quantity;
        final String string;
        final int num;

        Plural(String quantity, String string) {
            this.quantity = quantity;
            this.string = string;
            this.num = "zero".equals(quantity) ? 0 : ("one".equals(quantity) ? 1 : ("two".equals(quantity) ? 2 : ("other".equals(quantity) ? -1 : -1)));
        }
    }

    static class PluralRules {
        List<Plural> plurals = new ArrayList<Plural>();

        PluralRules() {
        }

        Plural find(int quantity) {
            for (Plural p : this.plurals) {
                if (p.num != quantity) continue;
                return p;
            }
            for (Plural p : this.plurals) {
                if (p.num != -1) continue;
                return p;
            }
            return null;
        }

        void add(Plural p) {
            this.plurals.add(p);
        }
    }
}

