/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.res;

import com.xtremelabs.robolectric.res.ResourceExtractor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class RawResourceLoader {
    private ResourceExtractor resourceExtractor;
    private File resourceDir;

    public RawResourceLoader(ResourceExtractor resourceExtractor, File resourceDir) {
        this.resourceExtractor = resourceExtractor;
        this.resourceDir = resourceDir;
    }

    public InputStream getValue(int resourceId) {
        String resourceFileName = this.resourceExtractor.getResourceName(resourceId);
        String resourceName = resourceFileName.substring("/raw".length());
        File rawResourceDir = new File(this.resourceDir, "raw");
        try {
            File[] files = rawResourceDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                String name = file.getName();
                int dotIndex = name.indexOf(".");
                String fileBaseName = null;
                fileBaseName = dotIndex >= 0 ? name.substring(0, dotIndex) : name;
                if (!fileBaseName.equals(resourceName)) continue;
                return new FileInputStream(file);
            }
        }
        catch (FileNotFoundException e) {
            return null;
        }
        return null;
    }
}

