/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.res;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public class ResourceExtractor {
    private Map<String, Integer> localResourceStringToId = new HashMap<String, Integer>();
    private Map<String, Integer> systemResourceStringToId = new HashMap<String, Integer>();
    private Map<Integer, String> resourceIdToString = new HashMap<Integer, String>();

    public void addLocalRClass(Class rClass) throws Exception {
        this.addRClass(rClass, false);
    }

    public void addSystemRClass(Class rClass) throws Exception {
        this.addRClass(rClass, true);
    }

    private void addRClass(Class rClass, boolean isSystemRClass) throws Exception {
        for (Class<?> innerClass : rClass.getClasses()) {
            for (Field field : innerClass.getDeclaredFields()) {
                if (!field.getType().equals(Integer.TYPE) || !Modifier.isStatic(field.getModifiers())) continue;
                String section = innerClass.getSimpleName();
                String name = section + "/" + field.getName();
                int value = field.getInt(null);
                if (isSystemRClass) {
                    name = "android:" + name;
                }
                if (section.equals("styleable")) continue;
                if (isSystemRClass) {
                    this.systemResourceStringToId.put(name, value);
                } else {
                    this.localResourceStringToId.put(name, value);
                }
                if (this.resourceIdToString.containsKey(value)) {
                    throw new RuntimeException(value + " is already defined with name: " + this.resourceIdToString.get(value) + " can't also call it: " + name);
                }
                this.resourceIdToString.put(value, name);
            }
        }
    }

    public Integer getResourceId(String resourceName) {
        if (resourceName.contains("android:")) {
            return this.getResourceId(resourceName, true);
        }
        return this.getResourceId(resourceName, false);
    }

    public Integer getLocalResourceId(String value) {
        boolean isSystem = false;
        return this.getResourceId(value, isSystem);
    }

    public Integer getResourceId(String resourceName, boolean isSystemResource) {
        if (resourceName == null) {
            return null;
        }
        if (resourceName.equals("@null")) {
            return 0;
        }
        if (resourceName.startsWith("@+id")) {
            resourceName = resourceName.substring(2);
        } else if (resourceName.startsWith("@+android:id")) {
            resourceName = resourceName.substring(2);
        } else if (resourceName.startsWith("@")) {
            resourceName = resourceName.substring(1);
        }
        if (isSystemResource) {
            return this.systemResourceStringToId.get(resourceName);
        }
        return this.localResourceStringToId.get(resourceName);
    }

    public String getResourceName(int resourceId) {
        return this.resourceIdToString.get(resourceId);
    }
}

