/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.res;

import android.R;
import android.content.Context;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.preference.PreferenceScreen;
import android.view.Menu;
import android.view.View;
import android.view.ViewGroup;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.res.AttrResourceLoader;
import com.xtremelabs.robolectric.res.ColorResourceLoader;
import com.xtremelabs.robolectric.res.DimenResourceLoader;
import com.xtremelabs.robolectric.res.DocumentLoader;
import com.xtremelabs.robolectric.res.DrawableResourceLoader;
import com.xtremelabs.robolectric.res.IntegerResourceLoader;
import com.xtremelabs.robolectric.res.MenuLoader;
import com.xtremelabs.robolectric.res.PluralResourceLoader;
import com.xtremelabs.robolectric.res.PreferenceLoader;
import com.xtremelabs.robolectric.res.RawResourceLoader;
import com.xtremelabs.robolectric.res.ResourceExtractor;
import com.xtremelabs.robolectric.res.StringArrayResourceLoader;
import com.xtremelabs.robolectric.res.StringResourceLoader;
import com.xtremelabs.robolectric.res.ViewLoader;
import com.xtremelabs.robolectric.shadows.ShadowApplication;
import com.xtremelabs.robolectric.shadows.ShadowContext;
import com.xtremelabs.robolectric.util.I18nException;
import com.xtremelabs.robolectric.util.PropertiesHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ResourceLoader {
    private static final FileFilter MENU_DIR_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return ResourceLoader.isMenuDirectory(file.getPath());
        }
    };
    private static final FileFilter LAYOUT_DIR_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return ResourceLoader.isLayoutDirectory(file.getPath());
        }
    };
    private static final FileFilter DRAWABLE_DIR_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return ResourceLoader.isDrawableDirectory(file.getPath());
        }
    };
    private File resourceDir;
    private File assetsDir;
    private int sdkVersion;
    private Class rClass;
    private final ResourceExtractor resourceExtractor;
    private ViewLoader viewLoader;
    private MenuLoader menuLoader;
    private PreferenceLoader preferenceLoader;
    private final StringResourceLoader stringResourceLoader;
    private final PluralResourceLoader pluralResourceLoader;
    private final StringArrayResourceLoader stringArrayResourceLoader;
    private final AttrResourceLoader attrResourceLoader;
    private final ColorResourceLoader colorResourceLoader;
    private final DrawableResourceLoader drawableResourceLoader;
    private final RawResourceLoader rawResourceLoader;
    private final DimenResourceLoader dimenResourceLoader;
    private final IntegerResourceLoader integerResourceLoader;
    private boolean isInitialized = false;
    private boolean strictI18n = false;
    public final Map<Integer, Integer> dimensions = new HashMap<Integer, Integer>();

    public ResourceLoader(int sdkVersion, Class rClass, File resourceDir, File assetsDir) throws Exception {
        this.sdkVersion = sdkVersion;
        this.assetsDir = assetsDir;
        this.rClass = rClass;
        this.resourceExtractor = new ResourceExtractor();
        this.resourceExtractor.addLocalRClass(rClass);
        this.resourceExtractor.addSystemRClass(R.class);
        this.stringResourceLoader = new StringResourceLoader(this.resourceExtractor);
        this.pluralResourceLoader = new PluralResourceLoader(this.resourceExtractor, this.stringResourceLoader);
        this.stringArrayResourceLoader = new StringArrayResourceLoader(this.resourceExtractor, this.stringResourceLoader);
        this.colorResourceLoader = new ColorResourceLoader(this.resourceExtractor);
        this.attrResourceLoader = new AttrResourceLoader(this.resourceExtractor);
        this.drawableResourceLoader = new DrawableResourceLoader(this.resourceExtractor, resourceDir);
        this.rawResourceLoader = new RawResourceLoader(this.resourceExtractor, resourceDir);
        this.dimenResourceLoader = new DimenResourceLoader(this.resourceExtractor);
        this.integerResourceLoader = new IntegerResourceLoader(this.resourceExtractor);
        this.resourceDir = resourceDir;
    }

    public void setStrictI18n(boolean strict) {
        this.strictI18n = strict;
        if (this.viewLoader != null) {
            this.viewLoader.setStrictI18n(strict);
        }
        if (this.menuLoader != null) {
            this.menuLoader.setStrictI18n(strict);
        }
        if (this.preferenceLoader != null) {
            this.preferenceLoader.setStrictI18n(strict);
        }
    }

    public boolean getStrictI18n() {
        return this.strictI18n;
    }

    private void init() {
        if (this.isInitialized) {
            return;
        }
        try {
            if (this.resourceDir != null) {
                this.viewLoader = new ViewLoader(this.resourceExtractor, this.attrResourceLoader);
                this.menuLoader = new MenuLoader(this.resourceExtractor, this.attrResourceLoader);
                this.preferenceLoader = new PreferenceLoader(this.resourceExtractor);
                this.viewLoader.setStrictI18n(this.strictI18n);
                this.menuLoader.setStrictI18n(this.strictI18n);
                this.preferenceLoader.setStrictI18n(this.strictI18n);
                File systemResourceDir = this.getSystemResourceDir(this.getPathToAndroidResources());
                File localValueResourceDir = this.getValueResourceDir(this.resourceDir);
                File systemValueResourceDir = this.getValueResourceDir(systemResourceDir);
                File preferenceDir = this.getPreferenceResourceDir(this.resourceDir);
                this.loadStringResources(localValueResourceDir, systemValueResourceDir);
                this.loadPluralsResources(localValueResourceDir, systemValueResourceDir);
                this.loadValueResources(localValueResourceDir, systemValueResourceDir);
                this.loadDimenResources(localValueResourceDir, systemValueResourceDir);
                this.loadIntegerResource(localValueResourceDir, systemResourceDir);
                this.loadViewResources(systemResourceDir, this.resourceDir);
                this.loadMenuResources(this.resourceDir);
                this.loadDrawableResources(this.resourceDir);
                this.loadPreferenceResources(preferenceDir);
            } else {
                this.viewLoader = null;
                this.menuLoader = null;
                this.preferenceLoader = null;
            }
        }
        catch (I18nException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.isInitialized = true;
    }

    private File getSystemResourceDir(String pathToAndroidResources) {
        return pathToAndroidResources != null ? new File(pathToAndroidResources) : null;
    }

    private void loadStringResources(File localResourceDir, File systemValueResourceDir) throws Exception {
        DocumentLoader stringResourceDocumentLoader = new DocumentLoader(this.stringResourceLoader);
        this.loadValueResourcesFromDirs(stringResourceDocumentLoader, localResourceDir, systemValueResourceDir);
    }

    private void loadPluralsResources(File localResourceDir, File systemValueResourceDir) throws Exception {
        DocumentLoader stringResourceDocumentLoader = new DocumentLoader(this.pluralResourceLoader);
        this.loadValueResourcesFromDirs(stringResourceDocumentLoader, localResourceDir, systemValueResourceDir);
    }

    private void loadValueResources(File localResourceDir, File systemValueResourceDir) throws Exception {
        DocumentLoader valueResourceLoader = new DocumentLoader(this.stringArrayResourceLoader, this.colorResourceLoader, this.attrResourceLoader);
        this.loadValueResourcesFromDirs(valueResourceLoader, localResourceDir, systemValueResourceDir);
    }

    private void loadDimenResources(File localResourceDir, File systemValueResourceDir) throws Exception {
        DocumentLoader dimenResourceDocumentLoader = new DocumentLoader(this.dimenResourceLoader);
        this.loadValueResourcesFromDirs(dimenResourceDocumentLoader, localResourceDir, systemValueResourceDir);
    }

    private void loadIntegerResource(File localResourceDir, File systemValueResourceDir) throws Exception {
        DocumentLoader integerResourceDocumentLoader = new DocumentLoader(this.integerResourceLoader);
        this.loadValueResourcesFromDirs(integerResourceDocumentLoader, localResourceDir, systemValueResourceDir);
    }

    private void loadViewResources(File systemResourceDir, File xmlResourceDir) throws Exception {
        DocumentLoader viewDocumentLoader = new DocumentLoader(this.viewLoader);
        this.loadLayoutResourceXmlSubDirs(viewDocumentLoader, xmlResourceDir, false);
        this.loadLayoutResourceXmlSubDirs(viewDocumentLoader, systemResourceDir, true);
    }

    private void loadMenuResources(File xmlResourceDir) throws Exception {
        DocumentLoader menuDocumentLoader = new DocumentLoader(this.menuLoader);
        this.loadMenuResourceXmlDirs(menuDocumentLoader, xmlResourceDir);
    }

    private void loadDrawableResources(File xmlResourceDir) throws Exception {
        DocumentLoader drawableDocumentLoader = new DocumentLoader(this.drawableResourceLoader);
        this.loadDrawableResourceXmlDirs(drawableDocumentLoader, xmlResourceDir);
    }

    private void loadPreferenceResources(File xmlResourceDir) throws Exception {
        if (xmlResourceDir.exists()) {
            DocumentLoader preferenceDocumentLoader = new DocumentLoader(this.preferenceLoader);
            preferenceDocumentLoader.loadResourceXmlDir(xmlResourceDir);
        }
    }

    private void loadLayoutResourceXmlSubDirs(DocumentLoader layoutDocumentLoader, File xmlResourceDir, boolean isSystem) throws Exception {
        if (xmlResourceDir != null) {
            layoutDocumentLoader.loadResourceXmlDirs(isSystem, xmlResourceDir.listFiles(LAYOUT_DIR_FILE_FILTER));
        }
    }

    private void loadMenuResourceXmlDirs(DocumentLoader menuDocumentLoader, File xmlResourceDir) throws Exception {
        if (xmlResourceDir != null) {
            menuDocumentLoader.loadResourceXmlDirs(xmlResourceDir.listFiles(MENU_DIR_FILE_FILTER));
        }
    }

    private void loadDrawableResourceXmlDirs(DocumentLoader drawableResourceLoader, File xmlResourceDir) throws Exception {
        if (xmlResourceDir != null) {
            drawableResourceLoader.loadResourceXmlDirs(xmlResourceDir.listFiles(DRAWABLE_DIR_FILE_FILTER));
        }
    }

    private void loadValueResourcesFromDirs(DocumentLoader documentLoader, File localValueResourceDir, File systemValueResourceDir) throws Exception {
        this.loadValueResourcesFromDir(documentLoader, localValueResourceDir);
        this.loadSystemResourceXmlDir(documentLoader, systemValueResourceDir);
    }

    private void loadValueResourcesFromDir(DocumentLoader documentloader, File xmlResourceDir) throws Exception {
        if (xmlResourceDir != null) {
            documentloader.loadResourceXmlDir(xmlResourceDir);
        }
    }

    private void loadSystemResourceXmlDir(DocumentLoader documentLoader, File stringResourceDir) throws Exception {
        if (stringResourceDir != null) {
            documentLoader.loadSystemResourceXmlDir(stringResourceDir);
        }
    }

    private File getValueResourceDir(File xmlResourceDir) {
        return xmlResourceDir != null ? new File(xmlResourceDir, "values") : null;
    }

    private File getPreferenceResourceDir(File xmlResourceDir) {
        return xmlResourceDir != null ? new File(xmlResourceDir, "xml") : null;
    }

    private String getPathToAndroidResources() {
        String resourcePath = this.getAndroidResourcePathFromLocalProperties();
        if (resourcePath != null) {
            return resourcePath;
        }
        resourcePath = this.getAndroidResourcePathFromSystemEnvironment();
        if (resourcePath != null) {
            return resourcePath;
        }
        resourcePath = this.getAndroidResourcePathFromSystemProperty();
        if (resourcePath != null) {
            return resourcePath;
        }
        resourcePath = this.getAndroidResourcePathByExecingWhichAndroid();
        if (resourcePath != null) {
            return resourcePath;
        }
        System.out.println("WARNING: Unable to find path to Android SDK");
        return null;
    }

    private String getAndroidResourcePathFromLocalProperties() {
        String localPropertiesFileName;
        File rootDir = this.resourceDir.getParentFile();
        File localPropertiesFile = new File(rootDir, localPropertiesFileName = "local.properties");
        if (!localPropertiesFile.exists()) {
            localPropertiesFile = new File(localPropertiesFileName);
        }
        if (localPropertiesFile.exists()) {
            Properties localProperties = new Properties();
            try {
                localProperties.load(new FileInputStream(localPropertiesFile));
                PropertiesHelper.doSubstitutions(localProperties);
                String sdkPath = localProperties.getProperty("sdk.dir");
                if (sdkPath != null) {
                    return this.getResourcePathFromSdkPath(sdkPath);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return null;
    }

    private String getAndroidResourcePathFromSystemEnvironment() {
        String resourcePath = System.getenv().get("ANDROID_HOME");
        if (resourcePath != null) {
            return new File(resourcePath, this.getAndroidResourceSubPath()).toString();
        }
        return null;
    }

    private String getAndroidResourcePathFromSystemProperty() {
        String resourcePath = System.getProperty("android.sdk.path");
        if (resourcePath != null) {
            return new File(resourcePath, this.getAndroidResourceSubPath()).toString();
        }
        return null;
    }

    private String getAndroidResourcePathByExecingWhichAndroid() {
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"which", "android"});
            String sdkPath = new BufferedReader(new InputStreamReader(process.getInputStream())).readLine();
            if (sdkPath != null && sdkPath.endsWith("tools/android")) {
                return this.getResourcePathFromSdkPath(sdkPath.substring(0, sdkPath.indexOf("tools/android")));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private String getResourcePathFromSdkPath(String sdkPath) {
        File androidResourcePath = new File(sdkPath, this.getAndroidResourceSubPath());
        return androidResourcePath.exists() ? androidResourcePath.toString() : null;
    }

    private String getAndroidResourceSubPath() {
        return "platforms/android-" + this.sdkVersion + "/data/res";
    }

    static boolean isLayoutDirectory(String path) {
        return path.contains(File.separator + "layout");
    }

    static boolean isDrawableDirectory(String path) {
        return path.contains(File.separator + "drawable");
    }

    static boolean isMenuDirectory(String path) {
        return path.contains(File.separator + "menu");
    }

    protected ResourceLoader(StringResourceLoader stringResourceLoader) {
        this.resourceExtractor = new ResourceExtractor();
        this.stringResourceLoader = stringResourceLoader;
        this.pluralResourceLoader = null;
        this.viewLoader = null;
        this.stringArrayResourceLoader = null;
        this.attrResourceLoader = null;
        this.colorResourceLoader = null;
        this.drawableResourceLoader = null;
        this.rawResourceLoader = null;
        this.dimenResourceLoader = null;
        this.integerResourceLoader = null;
    }

    public static ResourceLoader getFrom(Context context) {
        ResourceLoader resourceLoader = Robolectric.shadowOf(context.getApplicationContext()).getResourceLoader();
        resourceLoader.init();
        return resourceLoader;
    }

    public String getNameForId(int viewId) {
        this.init();
        return this.resourceExtractor.getResourceName(viewId);
    }

    public View inflateView(Context context, int resource, ViewGroup viewGroup) {
        this.init();
        return this.viewLoader.inflateView(context, resource, (View)viewGroup);
    }

    public int getColorValue(int id) {
        this.init();
        return this.colorResourceLoader.getValue(id);
    }

    public String getStringValue(int id) {
        this.init();
        return this.stringResourceLoader.getValue(id);
    }

    public String getPluralStringValue(int id, int quantity) {
        this.init();
        return this.pluralResourceLoader.getValue(id, quantity);
    }

    public float getDimenValue(int id) {
        this.init();
        return this.dimenResourceLoader.getValue(id);
    }

    public int getIntegerValue(int id) {
        this.init();
        return this.integerResourceLoader.getValue(id);
    }

    public boolean isDrawableXml(int resourceId) {
        this.init();
        return this.drawableResourceLoader.isXml(resourceId);
    }

    public boolean isAnimatableXml(int resourceId) {
        this.init();
        return this.drawableResourceLoader.isAnimationDrawable(resourceId);
    }

    public int[] getDrawableIds(int resourceId) {
        this.init();
        return this.drawableResourceLoader.getDrawableIds(resourceId);
    }

    public Drawable getXmlDrawable(int resourceId) {
        return this.drawableResourceLoader.getXmlDrawable(resourceId);
    }

    public Drawable getAnimDrawable(int resourceId) {
        return this.getInnerRClassDrawable(resourceId, "$anim", AnimationDrawable.class);
    }

    public Drawable getColorDrawable(int resourceId) {
        return this.getInnerRClassDrawable(resourceId, "$color", ColorDrawable.class);
    }

    private Drawable getInnerRClassDrawable(int drawableResourceId, String suffix, Class returnClass) {
        ShadowApplication shadowApp = Robolectric.shadowOf(Robolectric.application);
        Class rClass = ((ShadowContext)shadowApp).getResourceLoader().getLocalRClass();
        if (rClass == null) {
            return null;
        }
        Class<?> animClass = null;
        try {
            animClass = Class.forName(rClass.getCanonicalName() + suffix);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        try {
            for (Field field : animClass.getDeclaredFields()) {
                if (field.getInt(animClass) != drawableResourceId) continue;
                return (Drawable)returnClass.newInstance();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    public InputStream getRawValue(int id) {
        this.init();
        return this.rawResourceLoader.getValue(id);
    }

    public String[] getStringArrayValue(int id) {
        this.init();
        return this.stringArrayResourceLoader.getArrayValue(id);
    }

    public void inflateMenu(Context context, int resource, Menu root) {
        this.init();
        this.menuLoader.inflateMenu(context, resource, root);
    }

    public PreferenceScreen inflatePreferences(Context context, int resourceId) {
        this.init();
        return this.preferenceLoader.inflatePreferences(context, resourceId);
    }

    public File getAssetsBase() {
        return this.assetsDir;
    }

    public Class getLocalRClass() {
        return this.rClass;
    }

    public void setLocalRClass(Class clazz) {
        this.rClass = clazz;
    }

    public ResourceExtractor getResourceExtractor() {
        return this.resourceExtractor;
    }

    public ViewLoader.ViewNode getLayoutViewNode(String layoutName) {
        return this.viewLoader.viewNodesByLayoutName.get(layoutName);
    }

    public void setLayoutQualifierSearchPath(String ... locations) {
        this.init();
        this.viewLoader.setLayoutQualifierSearchPath(locations);
    }
}

