/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.res;

import com.xtremelabs.robolectric.res.ResourceValueConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ResourceReferenceResolver<T> {
    private Map<String, T> attributeNamesToValues = new HashMap<String, T>();
    private Map<String, List<String>> unresolvedReferences = new HashMap<String, List<String>>();
    private String prefix;

    ResourceReferenceResolver(String prefix) {
        this.prefix = prefix;
    }

    public T getValue(String resourceName) {
        return this.attributeNamesToValues.get(resourceName);
    }

    public void processResource(String name, String rawValue, ResourceValueConverter loader, boolean isSystem) {
        String valuePointer = this.prefix + "/" + name;
        if (rawValue.startsWith("@" + this.prefix) || rawValue.startsWith("@android:" + this.prefix)) {
            this.addAttributeReference(rawValue, valuePointer);
        } else {
            if (isSystem) {
                valuePointer = "android:" + valuePointer;
            }
            this.addAttribute(valuePointer, loader.convertRawValue(rawValue));
        }
    }

    public void addAttribute(String valuePointer, T value) {
        this.attributeNamesToValues.put(valuePointer, value);
        this.resolveUnresolvedReferences(valuePointer, value);
    }

    private void resolveUnresolvedReferences(String attributeName, T value) {
        List<String> references = this.unresolvedReferences.remove(attributeName);
        if (references == null) {
            return;
        }
        for (String reference : references) {
            this.attributeNamesToValues.put(reference, value);
        }
    }

    private void addUnresolvedReference(String valuePointer, String attributeName) {
        List<String> references = this.unresolvedReferences.get(attributeName);
        if (references == null) {
            references = new ArrayList<String>();
            this.unresolvedReferences.put(attributeName, references);
        }
        references.add(valuePointer);
    }

    private void addAttributeReference(String rawValue, String valuePointer) {
        String attributeName = rawValue.substring(1);
        T value = this.attributeNamesToValues.get(attributeName);
        if (value == null) {
            this.addUnresolvedReference(valuePointer, attributeName);
        } else {
            this.attributeNamesToValues.put(valuePointer, value);
        }
    }
}

