/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.res;

import android.content.ComponentName;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import com.xtremelabs.robolectric.RobolectricConfig;
import com.xtremelabs.robolectric.tester.android.content.pm.StubPackageManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RobolectricPackageManager
extends StubPackageManager {
    private Map<String, PackageInfo> packageList;
    private Map<Intent, List<ResolveInfo>> resolveList = new HashMap<Intent, List<ResolveInfo>>();
    private Map<ComponentName, ComponentState> componentList = new HashMap<ComponentName, ComponentState>();
    private ContextWrapper contextWrapper;
    private RobolectricConfig config;
    private ApplicationInfo applicationInfo;

    public RobolectricPackageManager(ContextWrapper contextWrapper, RobolectricConfig config) {
        this.contextWrapper = contextWrapper;
        this.config = config;
        this.initializePackageInfo();
    }

    @Override
    public PackageInfo getPackageInfo(String packageName, int flags) throws PackageManager.NameNotFoundException {
        if (this.packageList.containsKey(packageName)) {
            return this.packageList.get(packageName);
        }
        throw new PackageManager.NameNotFoundException();
    }

    @Override
    public ApplicationInfo getApplicationInfo(String packageName, int flags) throws PackageManager.NameNotFoundException {
        if (this.config.getPackageName().equals(packageName)) {
            if (this.applicationInfo == null) {
                this.applicationInfo = new ApplicationInfo();
                this.applicationInfo.flags = this.config.getApplicationFlags();
                this.applicationInfo.targetSdkVersion = this.config.getSdkVersion();
                this.applicationInfo.packageName = this.config.getPackageName();
                this.applicationInfo.processName = this.config.getProcessName();
            }
            return this.applicationInfo;
        }
        PackageInfo info = this.packageList.get(packageName);
        if (info != null) {
            return info.applicationInfo;
        }
        throw new PackageManager.NameNotFoundException();
    }

    @Override
    public List<PackageInfo> getInstalledPackages(int flags) {
        return new ArrayList<PackageInfo>(this.packageList.values());
    }

    @Override
    public List<ResolveInfo> queryIntentActivities(Intent intent, int flags) {
        return this.resolveList.get(intent);
    }

    @Override
    public ResolveInfo resolveActivity(Intent intent, int flags) {
        List<ResolveInfo> candidates = this.queryIntentActivities(intent, flags);
        if (candidates == null) {
            return null;
        }
        return candidates.get(0);
    }

    public void addResolveInfoForIntent(Intent intent, List<ResolveInfo> info) {
        this.resolveList.put(intent, info);
    }

    @Override
    public Intent getLaunchIntentForPackage(String packageName) {
        Intent i = new Intent();
        i.setComponent(new ComponentName(packageName, ""));
        return i;
    }

    @Override
    public CharSequence getApplicationLabel(ApplicationInfo info) {
        return info.name;
    }

    @Override
    public void setComponentEnabledSetting(ComponentName componentName, int newState, int flags) {
        this.componentList.put(componentName, new ComponentState(newState, flags));
    }

    public ComponentState getComponentState(ComponentName componentName) {
        return this.componentList.get(componentName);
    }

    public void addPackage(PackageInfo packageInfo) {
        this.packageList.put(packageInfo.packageName, packageInfo);
    }

    public void addPackage(String packageName) {
        PackageInfo info = new PackageInfo();
        info.packageName = packageName;
        this.addPackage(info);
    }

    private void initializePackageInfo() {
        if (this.packageList != null) {
            return;
        }
        PackageInfo packageInfo = new PackageInfo();
        packageInfo.packageName = this.contextWrapper.getPackageName();
        packageInfo.versionName = "1.0";
        this.packageList = new HashMap<String, PackageInfo>();
        this.addPackage(packageInfo);
    }

    public class ComponentState {
        public int newState;
        public int flags;

        public ComponentState(int newState, int flags) {
            this.newState = newState;
            this.flags = flags;
        }
    }
}

