/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.res;

import com.xtremelabs.robolectric.res.ResourceExtractor;
import com.xtremelabs.robolectric.res.StringResourceLoader;
import com.xtremelabs.robolectric.res.XpathResourceXmlLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StringArrayResourceLoader
extends XpathResourceXmlLoader {
    Map<String, String[]> stringArrayValues = new HashMap<String, String[]>();
    private StringResourceLoader stringResourceLoader;

    public StringArrayResourceLoader(ResourceExtractor resourceExtractor, StringResourceLoader stringResourceLoader) {
        super(resourceExtractor, "/resources/string-array");
        this.stringResourceLoader = stringResourceLoader;
    }

    public String[] getArrayValue(int resourceId) {
        String resourceName = this.resourceExtractor.getResourceName(resourceId);
        return this.stringArrayValues.get(resourceName);
    }

    @Override
    protected void processNode(Node node, String name, boolean isSystem) throws XPathExpressionException {
        XPathExpression itemXPath = XPathFactory.newInstance().newXPath().compile("item");
        NodeList childNodes = (NodeList)itemXPath.evaluate(node, XPathConstants.NODESET);
        ArrayList<String> arrayValues = new ArrayList<String>();
        for (int j = 0; j < childNodes.getLength(); ++j) {
            Node childNode = childNodes.item(j);
            String value = childNode.getTextContent();
            if (value.startsWith("@")) {
                value = value.substring(1);
                arrayValues.add(this.stringResourceLoader.getValue(value, isSystem));
                continue;
            }
            arrayValues.add(value);
        }
        String valuePointer = (isSystem ? "android:" : "") + "array/" + name;
        this.stringArrayValues.put(valuePointer, arrayValues.toArray(new String[arrayValues.size()]));
    }
}

