/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.res;

import android.content.Context;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.res.AttrResourceLoader;
import com.xtremelabs.robolectric.res.ResourceExtractor;
import com.xtremelabs.robolectric.res.XmlLoader;
import com.xtremelabs.robolectric.tester.android.util.TestAttributeSet;
import com.xtremelabs.robolectric.util.I18nException;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ViewLoader
extends XmlLoader {
    protected Map<String, ViewNode> viewNodesByLayoutName = new HashMap<String, ViewNode>();
    private AttrResourceLoader attrResourceLoader;
    private List<String> qualifierSearchPath = new ArrayList<String>();

    public ViewLoader(ResourceExtractor resourceExtractor, AttrResourceLoader attrResourceLoader) {
        super(resourceExtractor);
        this.attrResourceLoader = attrResourceLoader;
    }

    @Override
    protected void processResourceXml(File xmlFile, Document document, boolean isSystem) throws Exception {
        ViewNode topLevelNode = new ViewNode("top-level", new HashMap<String, String>(), isSystem);
        this.processChildren(document.getChildNodes(), topLevelNode);
        String layoutName = xmlFile.getParentFile().getName() + "/" + xmlFile.getName().replace(".xml", "");
        if (isSystem) {
            layoutName = "android:" + layoutName;
        }
        this.viewNodesByLayoutName.put(layoutName, topLevelNode.getChildren().get(0));
    }

    private void processChildren(NodeList childNodes, ViewNode parent) {
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            this.processNode(node, parent);
        }
    }

    private void processNode(Node node, ViewNode parent) {
        String name = node.getNodeName();
        NamedNodeMap attributes = node.getAttributes();
        HashMap<String, String> attrMap = new HashMap<String, String>();
        if (attributes != null) {
            int length = attributes.getLength();
            for (int i = 0; i < length; ++i) {
                Node attr = attributes.item(i);
                attrMap.put(attr.getNodeName(), attr.getNodeValue());
            }
        }
        if (name.equals("requestFocus")) {
            parent.attributes.put("android:focus", "true");
            parent.requestFocusOverride = true;
        } else if (!name.startsWith("#")) {
            ViewNode viewNode = new ViewNode(name, attrMap, parent.isSystem);
            if (parent != null) {
                parent.addChild(viewNode);
            }
            this.processChildren(node.getChildNodes(), viewNode);
        }
    }

    public View inflateView(Context context, String key) {
        return this.inflateView(context, key, null);
    }

    public View inflateView(Context context, String key, View parent) {
        return this.inflateView(context, key, null, parent);
    }

    public View inflateView(Context context, int resourceId, View parent) {
        return this.inflateView(context, this.resourceExtractor.getResourceName(resourceId), parent);
    }

    private View inflateView(Context context, String layoutName, Map<String, String> attributes, View parent) {
        ViewNode viewNode = this.getViewNodeByLayoutName(layoutName);
        if (viewNode == null) {
            throw new RuntimeException("Could not find layout " + layoutName);
        }
        try {
            if (attributes != null) {
                for (Map.Entry<String, String> entry : attributes.entrySet()) {
                    if (entry.getKey().equals("layout")) continue;
                    viewNode.attributes.put(entry.getKey(), entry.getValue());
                }
            }
            return viewNode.inflate(context, parent);
        }
        catch (I18nException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("error inflating " + layoutName, e);
        }
    }

    private ViewNode getViewNodeByLayoutName(String layoutName) {
        if (layoutName.startsWith("layout/") && !this.qualifierSearchPath.isEmpty()) {
            String rawLayoutName = layoutName.substring("layout/".length());
            for (String location : this.qualifierSearchPath) {
                ViewNode foundNode = this.viewNodesByLayoutName.get("layout-" + location + "/" + rawLayoutName);
                if (foundNode == null) continue;
                return foundNode;
            }
        }
        return this.viewNodesByLayoutName.get(layoutName);
    }

    public void setLayoutQualifierSearchPath(String ... locations) {
        this.qualifierSearchPath = Arrays.asList(locations);
    }

    public class ViewNode {
        private String name;
        private final Map<String, String> attributes;
        private List<ViewNode> children = new ArrayList<ViewNode>();
        boolean requestFocusOverride = false;
        boolean isSystem = false;

        public ViewNode(String name, Map<String, String> attributes, boolean isSystem) {
            this.name = name;
            this.attributes = attributes;
            this.isSystem = isSystem;
        }

        public List<ViewNode> getChildren() {
            return this.children;
        }

        public void addChild(ViewNode viewNode) {
            this.children.add(viewNode);
        }

        public View inflate(Context context, View parent) throws Exception {
            View view = this.create(context, (ViewGroup)parent);
            for (ViewNode child : this.children) {
                child.inflate(context, view);
            }
            this.invokeOnFinishInflate(view);
            return view;
        }

        private void invokeOnFinishInflate(View view) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
            Method onFinishInflate = View.class.getDeclaredMethod("onFinishInflate", new Class[0]);
            onFinishInflate.setAccessible(true);
            onFinishInflate.invoke((Object)view, new Object[0]);
        }

        private View create(Context context, ViewGroup parent) throws Exception {
            if (this.name.equals("include")) {
                String layout = this.attributes.get("layout");
                View view = ViewLoader.this.inflateView(context, layout.substring(1), this.attributes, (View)parent);
                return view;
            }
            if (this.name.equals("merge")) {
                return parent;
            }
            if (this.name.equals("fragment")) {
                FrameLayout fragment = this.constructFragment(context);
                this.addToParent(parent, (View)fragment);
                return fragment;
            }
            this.applyFocusOverride((ViewParent)parent);
            View view = this.constructView(context);
            this.addToParent(parent, view);
            Robolectric.shadowOf(view).applyFocus();
            return view;
        }

        private FrameLayout constructFragment(Context context) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            TestAttributeSet attributeSet = new TestAttributeSet(this.attributes, ViewLoader.this.resourceExtractor, ViewLoader.this.attrResourceLoader, View.class, this.isSystem);
            if (ViewLoader.this.strictI18n) {
                attributeSet.validateStrictI18n();
            }
            Class<? extends Fragment> clazz = this.loadFragmentClass(this.attributes.get("android:name"));
            Fragment fragment = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (!(context instanceof FragmentActivity)) {
                throw new RuntimeException("Cannot inflate a fragment unless the activity is a FragmentActivity");
            }
            FragmentActivity activity = (FragmentActivity)context;
            String tag = attributeSet.getAttributeValue("android", "tag");
            int id = attributeSet.getAttributeResourceValue("android", "id", 0);
            activity.getSupportFragmentManager().beginTransaction().add(id, fragment, tag).commit();
            View view = fragment.getView();
            FrameLayout container = new FrameLayout(context);
            container.setId(id);
            container.addView(view);
            return container;
        }

        private void addToParent(ViewGroup parent, View view) {
            if (parent != null && parent != view) {
                parent.addView(view);
            }
        }

        private View constructView(Context context) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            Class<? extends View> clazz = this.pickViewClass();
            try {
                TestAttributeSet attributeSet = new TestAttributeSet(this.attributes, ViewLoader.this.resourceExtractor, ViewLoader.this.attrResourceLoader, clazz, this.isSystem);
                if (ViewLoader.this.strictI18n) {
                    attributeSet.validateStrictI18n();
                }
                return clazz.getConstructor(Context.class, AttributeSet.class).newInstance(context, attributeSet);
            }
            catch (NoSuchMethodException e) {
                try {
                    return clazz.getConstructor(Context.class).newInstance(context);
                }
                catch (NoSuchMethodException e1) {
                    return clazz.getConstructor(Context.class, String.class).newInstance(context, "");
                }
            }
        }

        private Class<? extends View> pickViewClass() {
            Class<? extends View> clazz = this.loadViewClass(this.name);
            if (clazz == null) {
                clazz = this.loadViewClass("android.view." + this.name);
            }
            if (clazz == null) {
                clazz = this.loadViewClass("android.widget." + this.name);
            }
            if (clazz == null) {
                clazz = this.loadViewClass("android.webkit." + this.name);
            }
            if (clazz == null) {
                clazz = this.loadViewClass("com.google.android.maps." + this.name);
            }
            if (clazz == null) {
                throw new RuntimeException("couldn't find view class " + this.name);
            }
            return clazz;
        }

        private Class loadClass(String className) {
            try {
                return this.getClass().getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        private Class<? extends View> loadViewClass(String className) {
            return this.loadClass(className);
        }

        private Class<? extends Fragment> loadFragmentClass(String className) {
            return this.loadClass(className);
        }

        public void applyFocusOverride(ViewParent parent) {
            if (this.requestFocusOverride) {
                View ancestor = (View)parent;
                while (ancestor.getParent() != null) {
                    ancestor = (View)ancestor.getParent();
                }
                ancestor.clearFocus();
            }
        }
    }
}

