/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.content.ContentResolver;
import android.database.AbstractCursor;
import android.database.CursorWindow;
import android.net.Uri;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.internal.RealObject;
import java.util.HashMap;
import java.util.Map;

@Implements(value=AbstractCursor.class)
public class ShadowAbstractCursor {
    @RealObject
    private AbstractCursor realAbstractCursor;
    protected Map<String, Object> currentRow;
    protected int currentRowNumber = -1;
    protected Map<String, Integer> columnNames = new HashMap<String, Integer>();
    protected String[] columnNameArray;
    protected Map<Integer, Map<String, Object>> rows = new HashMap<Integer, Map<String, Object>>();
    protected int rowCount;
    protected Uri notificationUri;

    @Implementation
    public int getCount() {
        return this.rowCount;
    }

    @Implementation
    public boolean moveToFirst() {
        this.setPosition(0);
        return this.realAbstractCursor.getCount() > 0;
    }

    @Implementation
    public boolean moveToLast() {
        if (this.realAbstractCursor.getCount() == 0) {
            return false;
        }
        this.setPosition(this.realAbstractCursor.getCount() - 1);
        return true;
    }

    @Implementation
    public int getPosition() {
        return this.currentRowNumber;
    }

    @Implementation
    public boolean moveToPosition(int pos) {
        if (pos >= this.realAbstractCursor.getCount()) {
            return false;
        }
        this.setPosition(pos);
        return true;
    }

    private void setPosition(int pos) {
        this.currentRowNumber = pos;
        this.currentRow = -1 == this.currentRowNumber || this.rowCount == this.currentRowNumber ? null : this.rows.get(this.currentRowNumber);
    }

    @Implementation
    public boolean moveToNext() {
        if (this.currentRowNumber + 1 >= this.realAbstractCursor.getCount()) {
            this.currentRowNumber = this.realAbstractCursor.getCount();
            return false;
        }
        this.setPosition(++this.currentRowNumber);
        return true;
    }

    @Implementation
    public boolean moveToPrevious() {
        if (this.currentRowNumber < 0 || this.realAbstractCursor.getCount() == 0) {
            return false;
        }
        this.setPosition(--this.currentRowNumber);
        return true;
    }

    @Implementation
    public CursorWindow getWindow() {
        return null;
    }

    @Implementation
    public String[] getColumnNames() {
        return this.columnNameArray;
    }

    @Implementation
    public String getColumnName(int column) {
        return this.columnNameArray[column];
    }

    @Implementation
    public int getColumnIndex(String columnName) {
        for (int i = 0; i < this.columnNameArray.length; ++i) {
            if (!columnName.equals(this.columnNameArray[i])) continue;
            return i;
        }
        return -1;
    }

    @Implementation
    public int getColumnIndexOrThrow(String columnName) {
        int idx = this.getColumnIndex(columnName);
        if (idx >= 0) {
            return idx;
        }
        throw new IllegalArgumentException("column does not exist");
    }

    @Implementation
    public int getColumnCount() {
        return this.getColumnNames().length;
    }

    @Implementation
    public boolean isFirst() {
        return this.currentRowNumber == 0;
    }

    @Implementation
    public boolean isLast() {
        return this.currentRowNumber == this.realAbstractCursor.getCount() - 1;
    }

    @Implementation
    public boolean isBeforeFirst() {
        return this.currentRowNumber < 0;
    }

    @Implementation
    public boolean isAfterLast() {
        return this.currentRowNumber >= this.realAbstractCursor.getCount();
    }

    @Implementation
    public void setNotificationUri(ContentResolver cr, Uri notifyUri) {
        this.notificationUri = notifyUri;
    }

    public Uri getNotificationUri_Compatibility() {
        return this.notificationUri;
    }
}

