/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.accounts.Account;
import android.os.Parcel;
import android.text.TextUtils;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.internal.RealObject;
import java.lang.reflect.Field;

@Implements(value=Account.class)
public class ShadowAccount {
    @RealObject
    private Account realObject;

    public void __constructor__(String name, String type) throws Exception {
        this.set(name, type);
    }

    public void __constructor__(Parcel parcel) throws Exception {
        this.set(parcel.readString(), parcel.readString());
    }

    @Implementation
    public String toString() {
        return "Account {name=" + this.realObject.name + ", type=" + this.realObject.type + "}";
    }

    private void set(String name, String type) throws Exception {
        if (TextUtils.isEmpty((CharSequence)name) || TextUtils.isEmpty((CharSequence)type)) {
            throw new IllegalArgumentException();
        }
        Field nameF = this.realObject.getClass().getField("name");
        nameF.setAccessible(true);
        nameF.set(this.realObject, name);
        Field typeF = this.realObject.getClass().getField("type");
        typeF.setAccessible(true);
        typeF.set(this.realObject, type);
    }

    @Implementation
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Account)) {
            return false;
        }
        Account other = (Account)o;
        return this.realObject.name.equals(other.name) && this.realObject.type.equals(other.type);
    }

    @Implementation
    public int hashCode() {
        int result = 17;
        result = 31 * result + this.realObject.name.hashCode();
        result = 31 * result + this.realObject.type.hashCode();
        return result;
    }
}

