/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.app.Activity;
import android.app.Application;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MenuInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.internal.RealObject;
import com.xtremelabs.robolectric.shadows.ShadowContextWrapper;
import com.xtremelabs.robolectric.shadows.ShadowPreferenceManager;
import com.xtremelabs.robolectric.tester.android.view.TestWindow;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Implements(value=Activity.class)
public class ShadowActivity
extends ShadowContextWrapper {
    @RealObject
    protected Activity realActivity;
    private Intent intent;
    View contentView;
    private int orientation;
    private int resultCode;
    private Intent resultIntent;
    private Activity parent;
    private boolean finishWasCalled;
    private TestWindow window;
    private List<IntentForResult> startedActivitiesForResults = new ArrayList<IntentForResult>();
    private Map<Intent, Integer> intentRequestCodeMap = new HashMap<Intent, Integer>();
    private int requestedOrientation = -1;
    private View currentFocus;
    private Integer lastShownDialogId = null;
    private int pendingTransitionEnterAnimResId = -1;
    private int pendingTransitionExitAnimResId = -1;
    private Object lastNonConfigurationInstance;
    private Map<Integer, Dialog> dialogForId = new HashMap<Integer, Dialog>();
    private CharSequence title;
    private boolean onKeyUpWasCalled;

    @Implementation
    public final Application getApplication() {
        return Robolectric.application;
    }

    @Implementation
    public final Application getApplicationContext() {
        return this.getApplication();
    }

    @Implementation
    public void setIntent(Intent intent) {
        this.intent = intent;
    }

    @Implementation
    public Intent getIntent() {
        return this.intent;
    }

    @Implementation(i18nSafe=false)
    public void setTitle(CharSequence title) {
        this.title = title;
    }

    @Implementation
    public void setTitle(int titleId) {
        this.title = this.getResources().getString(titleId);
    }

    @Implementation
    public CharSequence getTitle() {
        return this.title;
    }

    @Implementation
    public void setContentView(int layoutResID) {
        this.contentView = this.getLayoutInflater().inflate(layoutResID, (ViewGroup)new FrameLayout((Context)this.realActivity));
        this.realActivity.onContentChanged();
    }

    @Implementation
    public void setContentView(View view) {
        this.contentView = view;
        this.realActivity.onContentChanged();
    }

    @Implementation
    public final void setResult(int resultCode) {
        this.resultCode = resultCode;
    }

    @Implementation
    public final void setResult(int resultCode, Intent data) {
        this.resultCode = resultCode;
        this.resultIntent = data;
    }

    @Implementation
    public LayoutInflater getLayoutInflater() {
        return LayoutInflater.from((Context)this.realActivity);
    }

    @Implementation
    public MenuInflater getMenuInflater() {
        return new MenuInflater((Context)this.realActivity);
    }

    @Implementation
    public View findViewById(int id) {
        if (this.contentView != null) {
            return this.contentView.findViewById(id);
        }
        System.out.println("WARNING: you probably should have called setContentView() first");
        Thread.dumpStack();
        return null;
    }

    @Implementation
    public final Activity getParent() {
        return this.parent;
    }

    @Implementation
    public void onBackPressed() {
        this.finish();
    }

    @Implementation
    public void finish() {
        this.finishWasCalled = true;
    }

    public void resetIsFinishing() {
        this.finishWasCalled = false;
    }

    @Implementation
    public boolean isFinishing() {
        return this.finishWasCalled;
    }

    @Implementation
    public Window getWindow() {
        if (this.window == null) {
            this.window = new TestWindow((Context)this.realActivity);
        }
        return this.window;
    }

    @Implementation
    public void runOnUiThread(Runnable action) {
        Robolectric.getUiThreadScheduler().post(action);
    }

    @Implementation
    public void onCreate(Bundle bundle) {
    }

    @Implementation
    public void onDestroy() {
        this.assertNoBroadcastListenersRegistered();
    }

    @Implementation
    public WindowManager getWindowManager() {
        return (WindowManager)Robolectric.application.getSystemService("window");
    }

    @Implementation
    public void setRequestedOrientation(int requestedOrientation) {
        this.requestedOrientation = requestedOrientation;
    }

    @Implementation
    public int getRequestedOrientation() {
        return this.requestedOrientation;
    }

    @Implementation
    public SharedPreferences getPreferences(int mode) {
        return ShadowPreferenceManager.getDefaultSharedPreferences((Context)this.getApplicationContext());
    }

    public void assertNoBroadcastListenersRegistered() {
        Robolectric.shadowOf(this.getApplicationContext()).assertNoBroadcastListenersRegistered((Context)this.realActivity, "Activity");
    }

    public View getContentView() {
        return this.contentView;
    }

    public int getResultCode() {
        return this.resultCode;
    }

    public Intent getResultIntent() {
        return this.resultIntent;
    }

    public IntentForResult getNextStartedActivityForResult() {
        if (this.startedActivitiesForResults.isEmpty()) {
            return null;
        }
        return this.startedActivitiesForResults.remove(0);
    }

    public IntentForResult peekNextStartedActivityForResult() {
        if (this.startedActivitiesForResults.isEmpty()) {
            return null;
        }
        return this.startedActivitiesForResults.get(0);
    }

    @Implementation
    public Object getLastNonConfigurationInstance() {
        return this.lastNonConfigurationInstance;
    }

    public void setLastNonConfigurationInstance(Object lastNonConfigurationInstance) {
        this.lastNonConfigurationInstance = lastNonConfigurationInstance;
    }

    public void setCurrentFocus(View view) {
        this.currentFocus = view;
    }

    @Implementation
    public View getCurrentFocus() {
        return this.currentFocus;
    }

    @Implementation
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        this.onKeyUpWasCalled = true;
        if (keyCode == 4) {
            this.onBackPressed();
            return true;
        }
        return false;
    }

    public boolean onKeyUpWasCalled() {
        return this.onKeyUpWasCalled;
    }

    public void resetKeyUpWasCalled() {
        this.onKeyUpWasCalled = false;
    }

    @Implementation
    public void startActivityForResult(Intent intent, int requestCode) {
        this.intentRequestCodeMap.put(intent, requestCode);
        this.startedActivitiesForResults.add(new IntentForResult(intent, requestCode));
        this.getApplicationContext().startActivity(intent);
    }

    public void receiveResult(Intent requestIntent, int resultCode, Intent resultIntent) {
        Integer requestCode = this.intentRequestCodeMap.get(requestIntent);
        if (requestCode == null) {
            throw new RuntimeException("No intent matches " + requestIntent + " among " + this.intentRequestCodeMap.keySet());
        }
        try {
            Method method = Activity.class.getDeclaredMethod("onActivityResult", Integer.TYPE, Integer.TYPE, Intent.class);
            method.setAccessible(true);
            method.invoke((Object)this.realActivity, requestCode, resultCode, resultIntent);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    @Implementation
    public final void showDialog(int id) {
        this.showDialog(id, null);
    }

    @Implementation
    public final void dismissDialog(int id) {
        Dialog dialog = this.dialogForId.get(id);
        if (dialog == null) {
            throw new IllegalArgumentException();
        }
        dialog.dismiss();
    }

    @Implementation
    public final void removeDialog(int id) {
        this.dialogForId.remove(id);
    }

    @Implementation
    public final boolean showDialog(int id, Bundle bundle) {
        Dialog dialog = null;
        this.lastShownDialogId = id;
        dialog = this.dialogForId.get(id);
        if (dialog == null) {
            try {
                Method method = Activity.class.getDeclaredMethod("onCreateDialog", Integer.TYPE);
                method.setAccessible(true);
                dialog = (Dialog)method.invoke((Object)this.realActivity, id);
                if (bundle == null) {
                    method = Activity.class.getDeclaredMethod("onPrepareDialog", Integer.TYPE, Dialog.class);
                    method.setAccessible(true);
                    method.invoke((Object)this.realActivity, id, dialog);
                } else {
                    method = Activity.class.getDeclaredMethod("onPrepareDialog", Integer.TYPE, Dialog.class, Bundle.class);
                    method.setAccessible(true);
                    method.invoke((Object)this.realActivity, id, dialog, bundle);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            this.dialogForId.put(id, dialog);
        }
        dialog.show();
        return true;
    }

    public Integer getLastShownDialogId() {
        return this.lastShownDialogId;
    }

    public boolean hasCancelledPendingTransitions() {
        return this.pendingTransitionEnterAnimResId == 0 && this.pendingTransitionExitAnimResId == 0;
    }

    @Implementation
    public void overridePendingTransition(int enterAnim, int exitAnim) {
        this.pendingTransitionEnterAnimResId = enterAnim;
        this.pendingTransitionExitAnimResId = exitAnim;
    }

    public Dialog getDialogById(int dialogId) {
        return this.dialogForId.get(dialogId);
    }

    public class IntentForResult {
        public Intent intent;
        public int requestCode;

        public IntentForResult(Intent intent, int requestCode) {
            this.intent = intent;
            this.requestCode = requestCode;
        }
    }
}

