/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.app.ActivityManager;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import java.util.ArrayList;
import java.util.List;

@Implements(value=ActivityManager.class)
public class ShadowActivityManager {
    private List<ActivityManager.RunningTaskInfo> tasks = new ArrayList<ActivityManager.RunningTaskInfo>();
    private List<ActivityManager.RunningAppProcessInfo> processes = new ArrayList<ActivityManager.RunningAppProcessInfo>();
    private String backgroundPackage;
    private ActivityManager.MemoryInfo memoryInfo;

    @Implementation
    public List<ActivityManager.RunningTaskInfo> getRunningTasks(int maxNum) {
        return this.tasks;
    }

    @Implementation
    public List<ActivityManager.RunningAppProcessInfo> getRunningAppProcesses() {
        return this.processes;
    }

    @Implementation
    public void killBackgroundProcesses(String packageName) {
        this.backgroundPackage = packageName;
    }

    @Implementation
    public void getMemoryInfo(ActivityManager.MemoryInfo outInfo) {
        if (this.memoryInfo != null) {
            outInfo.lowMemory = this.memoryInfo.lowMemory;
        }
    }

    public void setTasks(List<ActivityManager.RunningTaskInfo> tasks) {
        this.tasks = tasks;
    }

    public void setProcesses(List<ActivityManager.RunningAppProcessInfo> processes) {
        this.processes = processes;
    }

    public String getBackgroundPackage() {
        return this.backgroundPackage;
    }

    public void setMemoryInfo(ActivityManager.MemoryInfo memoryInfo) {
        this.memoryInfo = memoryInfo;
    }

    @Implements(value=ActivityManager.MemoryInfo.class)
    public static class ShadowMemoryInfo {
        public boolean lowMemory;

        public void setLowMemory(boolean lowMemory) {
            this.lowMemory = lowMemory;
        }
    }
}

