/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.database.DataSetObserver;
import android.os.Handler;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Adapter;
import android.widget.AdapterView;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.internal.RealObject;
import com.xtremelabs.robolectric.shadows.ShadowViewGroup;
import java.util.ArrayList;
import java.util.List;

@Implements(value=AdapterView.class)
public class ShadowAdapterView
extends ShadowViewGroup {
    private static int ignoreRowsAtEndOfList = 0;
    private static boolean automaticallyUpdateRowViews = true;
    @RealObject
    private AdapterView realAdapterView;
    private Adapter adapter;
    private View mEmptyView;
    private AdapterView.OnItemSelectedListener onItemSelectedListener;
    private AdapterView.OnItemClickListener onItemClickListener;
    private AdapterView.OnItemLongClickListener onItemLongClickListener;
    private boolean valid = false;
    private int selectedPosition;
    private int itemCount = 0;
    private List<Object> previousItems = new ArrayList<Object>();

    @Implementation
    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
        if (null != adapter) {
            adapter.registerDataSetObserver((DataSetObserver)new AdapterViewDataSetObserver());
        }
        this.invalidateAndScheduleUpdate();
        this.setSelection(0);
    }

    @Implementation
    public void setEmptyView(View emptyView) {
        this.mEmptyView = emptyView;
        this.updateEmptyStatus(this.adapter == null || this.adapter.isEmpty());
    }

    @Implementation
    public int getPositionForView(View view) {
        while (view.getParent() != null && view.getParent() != this.realView) {
            view = (View)view.getParent();
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (view != this.getChildAt(i)) continue;
            return i;
        }
        return -1;
    }

    private void invalidateAndScheduleUpdate() {
        this.valid = false;
        this.itemCount = this.adapter == null ? 0 : this.adapter.getCount();
        this.updateEmptyStatus(this.itemCount == 0);
        if (this.hasOnItemSelectedListener() && this.itemCount == 0) {
            this.onItemSelectedListener.onNothingSelected(this.realAdapterView);
        }
        new Handler().post(new Runnable(){

            @Override
            public void run() {
                if (!ShadowAdapterView.this.valid) {
                    ShadowAdapterView.this.update();
                    ShadowAdapterView.this.valid = true;
                }
            }
        });
    }

    private boolean hasOnItemSelectedListener() {
        return this.onItemSelectedListener != null;
    }

    private void updateEmptyStatus(boolean empty) {
        if (empty) {
            if (this.mEmptyView != null) {
                this.mEmptyView.setVisibility(0);
                this.setVisibility(8);
            } else {
                this.setVisibility(0);
            }
        } else {
            if (this.mEmptyView != null) {
                this.mEmptyView.setVisibility(8);
            }
            this.setVisibility(0);
        }
    }

    public boolean checkValidity() {
        this.update();
        return this.valid;
    }

    public static void ignoreRowsAtEndOfListDuringValidation(int countOfRows) {
        ignoreRowsAtEndOfList = countOfRows;
    }

    public static void automaticallyUpdateRowViews(boolean shouldUpdate) {
        automaticallyUpdateRowViews = shouldUpdate;
    }

    @Implementation
    public int getSelectedItemPosition() {
        return this.selectedPosition;
    }

    @Implementation
    public Object getSelectedItem() {
        int pos = this.getSelectedItemPosition();
        return this.getItemAtPosition(pos);
    }

    @Implementation
    public Adapter getAdapter() {
        return this.adapter;
    }

    @Implementation
    public int getCount() {
        return this.itemCount;
    }

    @Implementation
    public void setOnItemSelectedListener(AdapterView.OnItemSelectedListener listener) {
        this.onItemSelectedListener = listener;
    }

    @Implementation
    public final AdapterView.OnItemSelectedListener getOnItemSelectedListener() {
        return this.onItemSelectedListener;
    }

    @Implementation
    public void setOnItemClickListener(AdapterView.OnItemClickListener listener) {
        this.onItemClickListener = listener;
    }

    @Implementation
    public final AdapterView.OnItemClickListener getOnItemClickListener() {
        return this.onItemClickListener;
    }

    @Implementation
    public void setOnItemLongClickListener(AdapterView.OnItemLongClickListener listener) {
        this.onItemLongClickListener = listener;
    }

    @Implementation
    public Object getItemAtPosition(int position) {
        Adapter adapter = this.getAdapter();
        return adapter == null || position < 0 ? null : adapter.getItem(position);
    }

    @Implementation
    public long getItemIdAtPosition(int position) {
        Adapter adapter = this.getAdapter();
        return adapter == null || position < 0 ? Long.MIN_VALUE : adapter.getItemId(position);
    }

    @Implementation
    public void setSelection(final int position) {
        this.selectedPosition = position;
        if (this.selectedPosition >= 0) {
            new Handler().post(new Runnable(){

                @Override
                public void run() {
                    if (ShadowAdapterView.this.hasOnItemSelectedListener()) {
                        ShadowAdapterView.this.onItemSelectedListener.onItemSelected(ShadowAdapterView.this.realAdapterView, ShadowAdapterView.this.getChildAt(position), position, ShadowAdapterView.this.getAdapter().getItemId(position));
                    }
                }
            });
        }
    }

    @Implementation
    public boolean performItemClick(View view, int position, long id) {
        if (this.onItemClickListener != null) {
            this.onItemClickListener.onItemClick(this.realAdapterView, view, position, id);
            return true;
        }
        return false;
    }

    public boolean performItemLongClick(View view, int position, long id) {
        if (this.onItemLongClickListener != null) {
            this.onItemLongClickListener.onItemLongClick(this.realAdapterView, view, position, id);
            return true;
        }
        return false;
    }

    public boolean performItemClick(int position) {
        return this.realAdapterView.performItemClick(this.realAdapterView.getChildAt(position), position, this.realAdapterView.getItemIdAtPosition(position));
    }

    public int findIndexOfItemContainingText(String targetText) {
        for (int i = 0; i < this.realAdapterView.getChildCount(); ++i) {
            View childView = this.realAdapterView.getChildAt(i);
            String innerText = Robolectric.shadowOf(childView).innerText();
            if (!innerText.contains(targetText)) continue;
            return i;
        }
        return -1;
    }

    public View findItemContainingText(String targetText) {
        int itemIndex = this.findIndexOfItemContainingText(targetText);
        if (itemIndex == -1) {
            return null;
        }
        return this.realAdapterView.getChildAt(itemIndex);
    }

    public void clickFirstItemContainingText(String targetText) {
        int itemIndex = this.findIndexOfItemContainingText(targetText);
        if (itemIndex == -1) {
            throw new IllegalArgumentException("No item found containing text \"" + targetText + "\"");
        }
        this.performItemClick(itemIndex);
    }

    @Implementation
    public View getEmptyView() {
        return this.mEmptyView;
    }

    private void update() {
        if (!automaticallyUpdateRowViews) {
            return;
        }
        super.removeAllViews();
        this.addViews();
    }

    protected void addViews() {
        Adapter adapter = this.getAdapter();
        if (adapter != null) {
            if (this.valid && this.previousItems.size() - ignoreRowsAtEndOfList != adapter.getCount() - ignoreRowsAtEndOfList) {
                throw new ArrayIndexOutOfBoundsException("view is valid but adapter.getCount() has changed from " + this.previousItems.size() + " to " + adapter.getCount());
            }
            ArrayList<Object> newItems = new ArrayList<Object>();
            for (int i = 0; i < adapter.getCount() - ignoreRowsAtEndOfList; ++i) {
                View view = adapter.getView(i, null, (ViewGroup)this.realAdapterView);
                if (view != null) {
                    this.addView(view);
                }
                newItems.add(adapter.getItem(i));
            }
            if (this.valid && !((Object)newItems).equals(this.previousItems)) {
                throw new RuntimeException("view is valid but current items <" + newItems + "> don't match previous items <" + this.previousItems + ">");
            }
            this.previousItems = newItems;
        }
    }

    protected class AdapterViewDataSetObserver
    extends DataSetObserver {
        protected AdapterViewDataSetObserver() {
        }

        public void onChanged() {
            ShadowAdapterView.this.invalidateAndScheduleUpdate();
        }

        public void onInvalidated() {
            ShadowAdapterView.this.invalidateAndScheduleUpdate();
        }
    }
}

