/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Intent;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import java.util.ArrayList;
import java.util.List;

@Implements(value=AlarmManager.class)
public class ShadowAlarmManager {
    private List<ScheduledAlarm> scheduledAlarms = new ArrayList<ScheduledAlarm>();

    @Implementation
    public void set(int type, long triggerAtTime, PendingIntent operation) {
        Intent intent = Robolectric.shadowOf(operation).getSavedIntent();
        for (ScheduledAlarm scheduledAlarm : this.scheduledAlarms) {
            Intent scheduledIntent = Robolectric.shadowOf(scheduledAlarm.operation).getSavedIntent();
            if (!scheduledIntent.filterEquals(intent)) continue;
            this.scheduledAlarms.remove(scheduledAlarm);
            break;
        }
        this.scheduledAlarms.add(new ScheduledAlarm(type, triggerAtTime, operation));
    }

    public ScheduledAlarm getNextScheduledAlarm() {
        if (this.scheduledAlarms.isEmpty()) {
            return null;
        }
        return this.scheduledAlarms.remove(0);
    }

    public ScheduledAlarm peekNextScheduledAlarm() {
        if (this.scheduledAlarms.isEmpty()) {
            return null;
        }
        return this.scheduledAlarms.get(0);
    }

    public List<ScheduledAlarm> getScheduledAlarms() {
        return this.scheduledAlarms;
    }

    @Implementation
    public void cancel(PendingIntent pendingIntent) {
        Intent intentTypeToRemove = Robolectric.shadowOf(pendingIntent).getSavedIntent();
        for (ScheduledAlarm scheduledAlarm : new ArrayList<ScheduledAlarm>(this.scheduledAlarms)) {
            Intent alarmIntent = Robolectric.shadowOf(scheduledAlarm.operation).getSavedIntent();
            if (!intentTypeToRemove.filterEquals(alarmIntent)) continue;
            this.scheduledAlarms.remove(scheduledAlarm);
        }
    }

    public class ScheduledAlarm {
        public int type;
        public long triggerAtTime;
        public long interval;
        public PendingIntent operation;

        public ScheduledAlarm(int type, long triggerAtTime, PendingIntent operation) {
            this(type, triggerAtTime, 0L, operation);
        }

        public ScheduledAlarm(int type, long triggerAtTime, long interval, PendingIntent operation) {
            this.type = type;
            this.triggerAtTime = triggerAtTime;
            this.operation = operation;
            this.interval = interval;
        }
    }
}

