/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.View;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.internal.RealObject;
import com.xtremelabs.robolectric.shadows.ShadowDialog;
import java.lang.reflect.Constructor;

@Implements(value=AlertDialog.class)
public class ShadowAlertDialog
extends ShadowDialog {
    @RealObject
    private AlertDialog realAlertDialog;
    private CharSequence[] items;
    private String message;
    private DialogInterface.OnClickListener clickListener;
    private boolean isMultiItem;
    private boolean isSingleItem;
    private DialogInterface.OnMultiChoiceClickListener multiChoiceClickListener;
    private boolean[] checkedItems;
    private int checkedItemIndex;
    private Button positiveButton;
    private Button negativeButton;
    private Button neutralButton;
    private View view;
    private View customTitleView;
    private ListAdapter adapter;
    private ListView listView;

    public static AlertDialog getLatestAlertDialog() {
        ShadowAlertDialog dialog = Robolectric.getShadowApplication().getLatestAlertDialog();
        return dialog == null ? null : dialog.realAlertDialog;
    }

    @Override
    @Implementation
    public View findViewById(int viewId) {
        if (this.view == null) {
            return super.findViewById(viewId);
        }
        return this.view.findViewById(viewId);
    }

    @Implementation
    public void setView(View view) {
        this.view = view;
    }

    public static void reset() {
        Robolectric.getShadowApplication().setLatestAlertDialog(null);
    }

    public void clickOnItem(int index) {
        Robolectric.shadowOf(this.realAlertDialog.getListView()).performItemClick(index);
    }

    @Implementation
    public Button getButton(int whichButton) {
        switch (whichButton) {
            case -1: {
                return this.positiveButton;
            }
            case -2: {
                return this.negativeButton;
            }
            case -3: {
                return this.neutralButton;
            }
        }
        throw new RuntimeException("Only positive, negative, or neutral button choices are recognized");
    }

    @Implementation
    public ListView getListView() {
        if (this.listView == null) {
            this.listView = new ListView(this.context);
            this.listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                    if (ShadowAlertDialog.this.isMultiItem) {
                        ((ShadowAlertDialog)ShadowAlertDialog.this).checkedItems[position] = !ShadowAlertDialog.this.checkedItems[position];
                        ShadowAlertDialog.this.multiChoiceClickListener.onClick((DialogInterface)ShadowAlertDialog.this.realAlertDialog, position, ShadowAlertDialog.this.checkedItems[position]);
                    } else {
                        if (ShadowAlertDialog.this.isSingleItem) {
                            ShadowAlertDialog.this.checkedItemIndex = position;
                        }
                        ShadowAlertDialog.this.clickListener.onClick((DialogInterface)ShadowAlertDialog.this.realAlertDialog, position);
                    }
                }
            });
        }
        return this.listView;
    }

    public CharSequence[] getItems() {
        return this.items;
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    public String getMessage() {
        return this.message;
    }

    @Implementation
    public void setMessage(CharSequence message) {
        this.message = message == null ? null : ((Object)message).toString();
    }

    public boolean[] getCheckedItems() {
        return this.checkedItems;
    }

    public int getCheckedItemIndex() {
        return this.checkedItemIndex;
    }

    @Override
    @Implementation
    public void show() {
        super.show();
        if (this.items != null) {
            this.adapter = new ArrayAdapter(this.context, 17367045, 16908308, (Object[])this.items);
        }
        if (this.adapter != null) {
            this.getListView().setAdapter(this.adapter);
        }
        Robolectric.getShadowApplication().setLatestAlertDialog(this);
    }

    public View getView() {
        return this.view;
    }

    public View getCustomTitleView() {
        return this.customTitleView;
    }

    static /* synthetic */ CharSequence[] access$702(ShadowAlertDialog x0, CharSequence[] x1) {
        x0.items = x1;
        return x1;
    }

    static /* synthetic */ boolean[] access$102(ShadowAlertDialog x0, boolean[] x1) {
        x0.checkedItems = x1;
        return x1;
    }

    @Implements(value=AlertDialog.Builder.class)
    public static class ShadowBuilder {
        @RealObject
        private AlertDialog.Builder realBuilder;
        private CharSequence[] items;
        private ListAdapter adapter;
        private DialogInterface.OnClickListener clickListener;
        private DialogInterface.OnCancelListener cancelListener;
        private String title;
        private String message;
        private Context context;
        private boolean isMultiItem;
        private DialogInterface.OnMultiChoiceClickListener multiChoiceClickListener;
        private boolean[] checkedItems;
        private CharSequence positiveText;
        private DialogInterface.OnClickListener positiveListener;
        private CharSequence negativeText;
        private DialogInterface.OnClickListener negativeListener;
        private CharSequence neutralText;
        private DialogInterface.OnClickListener neutralListener;
        private boolean isCancelable;
        private boolean isSingleItem;
        private int checkedItem;
        private View view;
        private View customTitleView;

        public void __constructor__(Context context) {
            this.context = context;
        }

        @Implementation
        public AlertDialog.Builder setItems(int itemsId, DialogInterface.OnClickListener listener) {
            this.isMultiItem = false;
            this.items = this.context.getResources().getTextArray(itemsId);
            this.clickListener = listener;
            return this.realBuilder;
        }

        @Implementation(i18nSafe=false)
        public AlertDialog.Builder setItems(CharSequence[] items, DialogInterface.OnClickListener listener) {
            this.isMultiItem = false;
            this.items = items;
            this.clickListener = listener;
            return this.realBuilder;
        }

        @Implementation(i18nSafe=false)
        public AlertDialog.Builder setSingleChoiceItems(CharSequence[] items, int checkedItem, DialogInterface.OnClickListener listener) {
            this.isSingleItem = true;
            this.checkedItem = checkedItem;
            this.items = items;
            this.clickListener = listener;
            return this.realBuilder;
        }

        @Implementation(i18nSafe=false)
        public AlertDialog.Builder setSingleChoiceItems(ListAdapter adapter, int checkedItem, DialogInterface.OnClickListener listener) {
            this.isSingleItem = true;
            this.checkedItem = checkedItem;
            this.items = null;
            this.adapter = adapter;
            this.clickListener = listener;
            return this.realBuilder;
        }

        @Implementation(i18nSafe=false)
        public AlertDialog.Builder setMultiChoiceItems(CharSequence[] items, boolean[] checkedItems, DialogInterface.OnMultiChoiceClickListener listener) {
            this.isMultiItem = true;
            this.items = items;
            this.multiChoiceClickListener = listener;
            if (checkedItems == null) {
                checkedItems = new boolean[items.length];
            } else if (checkedItems.length != items.length) {
                throw new IllegalArgumentException("checkedItems must be the same length as items, or pass null to specify no checked items");
            }
            this.checkedItems = checkedItems;
            return this.realBuilder;
        }

        @Implementation(i18nSafe=false)
        public AlertDialog.Builder setTitle(CharSequence title) {
            this.title = ((Object)title).toString();
            return this.realBuilder;
        }

        @Implementation
        public AlertDialog.Builder setCustomTitle(View customTitleView) {
            this.customTitleView = customTitleView;
            return this.realBuilder;
        }

        @Implementation
        public AlertDialog.Builder setTitle(int titleId) {
            return this.setTitle(this.context.getResources().getString(titleId));
        }

        @Implementation(i18nSafe=false)
        public AlertDialog.Builder setMessage(CharSequence message) {
            this.message = ((Object)message).toString();
            return this.realBuilder;
        }

        @Implementation
        public AlertDialog.Builder setMessage(int messageId) {
            this.setMessage(this.context.getResources().getString(messageId));
            return this.realBuilder;
        }

        @Implementation
        public AlertDialog.Builder setIcon(int iconId) {
            return this.realBuilder;
        }

        @Implementation
        public AlertDialog.Builder setView(View view) {
            this.view = view;
            return this.realBuilder;
        }

        @Implementation(i18nSafe=false)
        public AlertDialog.Builder setPositiveButton(CharSequence text, DialogInterface.OnClickListener listener) {
            this.positiveText = text;
            this.positiveListener = listener;
            return this.realBuilder;
        }

        @Implementation
        public AlertDialog.Builder setPositiveButton(int positiveTextId, DialogInterface.OnClickListener listener) {
            return this.setPositiveButton(this.context.getResources().getText(positiveTextId), listener);
        }

        @Implementation(i18nSafe=false)
        public AlertDialog.Builder setNegativeButton(CharSequence text, DialogInterface.OnClickListener listener) {
            this.negativeText = text;
            this.negativeListener = listener;
            return this.realBuilder;
        }

        @Implementation
        public AlertDialog.Builder setNegativeButton(int negativeTextId, DialogInterface.OnClickListener listener) {
            return this.setNegativeButton(this.context.getResources().getString(negativeTextId), listener);
        }

        @Implementation(i18nSafe=false)
        public AlertDialog.Builder setNeutralButton(CharSequence text, DialogInterface.OnClickListener listener) {
            this.neutralText = text;
            this.neutralListener = listener;
            return this.realBuilder;
        }

        @Implementation
        public AlertDialog.Builder setNeutralButton(int neutralTextId, DialogInterface.OnClickListener listener) {
            return this.setNeutralButton(this.context.getResources().getText(neutralTextId), listener);
        }

        @Implementation
        public AlertDialog.Builder setCancelable(boolean cancelable) {
            this.isCancelable = cancelable;
            return this.realBuilder;
        }

        @Implementation
        public AlertDialog.Builder setOnCancelListener(DialogInterface.OnCancelListener listener) {
            this.cancelListener = listener;
            return this.realBuilder;
        }

        @Implementation
        public AlertDialog create() {
            AlertDialog realDialog;
            try {
                Constructor c = AlertDialog.class.getDeclaredConstructor(Context.class);
                c.setAccessible(true);
                realDialog = (AlertDialog)c.newInstance(new Object[]{null});
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            ShadowAlertDialog latestAlertDialog = Robolectric.shadowOf(realDialog);
            latestAlertDialog.context = this.context;
            ShadowAlertDialog.access$702(latestAlertDialog, this.items);
            latestAlertDialog.adapter = this.adapter;
            latestAlertDialog.setTitle(this.title);
            latestAlertDialog.message = this.message;
            latestAlertDialog.clickListener = this.clickListener;
            latestAlertDialog.setOnCancelListener(this.cancelListener);
            latestAlertDialog.isMultiItem = this.isMultiItem;
            latestAlertDialog.isSingleItem = this.isSingleItem;
            latestAlertDialog.checkedItemIndex = this.checkedItem;
            latestAlertDialog.multiChoiceClickListener = this.multiChoiceClickListener;
            ShadowAlertDialog.access$102(latestAlertDialog, this.checkedItems);
            latestAlertDialog.setView(this.view);
            latestAlertDialog.positiveButton = this.createButton((DialogInterface)realDialog, -1, this.positiveText, this.positiveListener);
            latestAlertDialog.negativeButton = this.createButton((DialogInterface)realDialog, -2, this.negativeText, this.negativeListener);
            latestAlertDialog.neutralButton = this.createButton((DialogInterface)realDialog, -3, this.neutralText, this.neutralListener);
            latestAlertDialog.setCancelable(this.isCancelable);
            latestAlertDialog.customTitleView = this.customTitleView;
            return realDialog;
        }

        @Implementation
        public AlertDialog show() {
            AlertDialog dialog = this.realBuilder.create();
            dialog.show();
            return dialog;
        }

        private Button createButton(final DialogInterface dialog, final int which, CharSequence text, final DialogInterface.OnClickListener listener) {
            if (text == null && listener == null) {
                return null;
            }
            Button button = new Button(this.context);
            Robolectric.shadowOf((TextView)button).setText(text);
            button.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (listener != null) {
                        listener.onClick(dialog, which);
                    }
                    dialog.dismiss();
                }
            });
            return button;
        }

        protected Context getContext() {
            return this.context;
        }
    }
}

