/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.ShadowAnimationBridge;
import android.view.animation.Transformation;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.internal.RealObject;

@Implements(value=Animation.class)
public class ShadowAnimation {
    private Animation.AnimationListener listener;
    private Interpolator interpolator;
    private boolean startFlag = false;
    private long durationMillis = 0L;
    private int repeatCount;
    private int repeatMode;
    private long startOffset;
    @RealObject
    private Animation realAnimation;

    @Implementation
    public void setAnimationListener(Animation.AnimationListener l) {
        this.listener = l;
    }

    @Implementation
    public void start() {
        this.startFlag = true;
        if (this.listener != null) {
            this.listener.onAnimationStart(this.realAnimation);
        }
    }

    @Implementation
    public void cancel() {
        this.startFlag = false;
        if (this.listener != null) {
            this.listener.onAnimationEnd(this.realAnimation);
        }
    }

    @Implementation
    public boolean hasStarted() {
        return this.startFlag;
    }

    @Implementation
    public void setDuration(long durationMillis) {
        this.durationMillis = durationMillis;
    }

    @Implementation
    public long getDuration() {
        return this.durationMillis;
    }

    @Implementation
    public void setInterpolator(Interpolator interpolator) {
        this.interpolator = interpolator;
    }

    @Implementation
    public Interpolator getInterpolator() {
        return this.interpolator;
    }

    @Implementation
    public void setRepeatCount(int repeatCount) {
        this.repeatCount = repeatCount;
    }

    @Implementation
    public int getRepeatCount() {
        return this.repeatCount;
    }

    @Implementation
    public void setRepeatMode(int repeatMode) {
        this.repeatMode = repeatMode;
    }

    @Implementation
    public int getRepeatMode() {
        return this.repeatMode;
    }

    @Implementation
    public void setStartOffset(long startOffset) {
        this.startOffset = startOffset;
    }

    @Implementation
    public long getStartOffset() {
        return this.startOffset;
    }

    public Animation.AnimationListener getAnimationListener() {
        return this.listener;
    }

    public void invokeRepeat() {
        if (this.listener != null) {
            this.listener.onAnimationRepeat(this.realAnimation);
        }
    }

    public void invokeEnd() {
        if (this.listener != null) {
            this.listener.onAnimationEnd(this.realAnimation);
        }
        new ShadowAnimationBridge(this.realAnimation).applyTransformation(1.0f, new Transformation());
    }
}

