/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.app.Activity;
import android.app.Application;
import android.appwidget.AppWidgetManager;
import android.appwidget.AppWidgetProvider;
import android.content.ComponentName;
import android.content.Context;
import android.view.View;
import android.widget.RemoteViews;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.AppSingletonizer;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.internal.RealObject;
import com.xtremelabs.robolectric.shadows.ShadowApplication;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@Implements(value=AppWidgetManager.class)
public class ShadowAppWidgetManager {
    private static AppSingletonizer<AppWidgetManager> instances = new AppSingletonizer<AppWidgetManager>(AppWidgetManager.class){

        @Override
        protected AppWidgetManager get(ShadowApplication shadowApplication) {
            return shadowApplication.appWidgetManager;
        }

        @Override
        protected void set(ShadowApplication shadowApplication, AppWidgetManager instance) {
            shadowApplication.appWidgetManager = instance;
        }

        @Override
        protected AppWidgetManager createInstance(Application applicationContext) {
            AppWidgetManager appWidgetManager = (AppWidgetManager)super.createInstance(applicationContext);
            Robolectric.shadowOf(appWidgetManager).context = (Context)applicationContext;
            return appWidgetManager;
        }
    };
    @RealObject
    private AppWidgetManager realAppWidgetManager;
    private Context context;
    private Map<Integer, WidgetInfo> widgetInfos = new HashMap<Integer, WidgetInfo>();
    private int nextWidgetId = 1;
    private boolean alwaysRecreateViewsDuringUpdate = false;

    private static void bind(AppWidgetManager appWidgetManager, Context context) {
    }

    @Implementation
    public static AppWidgetManager getInstance(Context context) {
        return instances.getInstance(context);
    }

    @Implementation
    public void updateAppWidget(int[] appWidgetIds, RemoteViews views) {
        for (int appWidgetId : appWidgetIds) {
            this.updateAppWidget(appWidgetId, views);
        }
    }

    @Implementation
    public void updateAppWidget(int appWidgetId, RemoteViews views) {
        WidgetInfo widgetInfo = this.getWidgetInfo(appWidgetId);
        int layoutId = views.getLayoutId();
        if (widgetInfo.layoutId != layoutId || this.alwaysRecreateViewsDuringUpdate) {
            widgetInfo.view = this.createWidgetView(layoutId);
            widgetInfo.layoutId = layoutId;
        }
        widgetInfo.lastRemoteViews = views;
        views.reapply(this.context, widgetInfo.view);
    }

    @Implementation
    public int[] getAppWidgetIds(ComponentName provider) {
        ArrayList<Integer> idList = new ArrayList<Integer>();
        for (int id : this.widgetInfos.keySet()) {
            WidgetInfo widgetInfo = this.widgetInfos.get(id);
            String widgetClass = widgetInfo.appWidgetProvider.getClass().getName();
            String widgetPackage = widgetInfo.appWidgetProvider.getClass().getPackage().getName();
            if (!provider.getClassName().equals(widgetClass) || !provider.getPackageName().equals(widgetPackage)) continue;
            idList.add(id);
        }
        int[] ids = new int[idList.size()];
        for (int i = 0; i < idList.size(); ++i) {
            ids[i] = (Integer)idList.get(i);
        }
        return ids;
    }

    public void reconstructWidgetViewAsIfPhoneWasRotated(int appWidgetId) {
        WidgetInfo widgetInfo = this.getWidgetInfo(appWidgetId);
        widgetInfo.view = this.createWidgetView(widgetInfo.layoutId);
        widgetInfo.lastRemoteViews.reapply(this.context, widgetInfo.view);
    }

    public int createWidget(Class<? extends AppWidgetProvider> appWidgetProviderClass, int widgetLayoutId) {
        return this.createWidgets(appWidgetProviderClass, widgetLayoutId, 1)[0];
    }

    public int[] createWidgets(Class<? extends AppWidgetProvider> appWidgetProviderClass, int widgetLayoutId, int howManyToCreate) {
        AppWidgetProvider appWidgetProvider = Robolectric.newInstanceOf(appWidgetProviderClass);
        int[] newWidgetIds = new int[howManyToCreate];
        for (int i = 0; i < howManyToCreate; ++i) {
            int myWidgetId;
            View widgetView = this.createWidgetView(widgetLayoutId);
            ++this.nextWidgetId;
            this.widgetInfos.put(myWidgetId, new WidgetInfo(widgetView, widgetLayoutId, appWidgetProvider));
            newWidgetIds[i] = myWidgetId;
        }
        appWidgetProvider.onUpdate(this.context, this.realAppWidgetManager, newWidgetIds);
        return newWidgetIds;
    }

    private void createWidgetProvider(Class<? extends AppWidgetProvider> appWidgetProviderClass, int ... newWidgetIds) {
        AppWidgetProvider appWidgetProvider = Robolectric.newInstanceOf(appWidgetProviderClass);
        appWidgetProvider.onUpdate(this.context, this.realAppWidgetManager, newWidgetIds);
    }

    private View createWidgetView(int widgetLayoutId) {
        return new Activity().getLayoutInflater().inflate(widgetLayoutId, null);
    }

    public View getViewFor(int widgetId) {
        return this.getWidgetInfo(widgetId).view;
    }

    public AppWidgetProvider getAppWidgetProviderFor(int widgetId) {
        return this.getWidgetInfo(widgetId).appWidgetProvider;
    }

    public void setAlwaysRecreateViewsDuringUpdate(boolean alwaysRecreate) {
        this.alwaysRecreateViewsDuringUpdate = alwaysRecreate;
    }

    public boolean getAlwaysRecreateViewsDuringUpdate() {
        return this.alwaysRecreateViewsDuringUpdate;
    }

    private WidgetInfo getWidgetInfo(int widgetId) {
        return this.widgetInfos.get(widgetId);
    }

    private class WidgetInfo {
        private View view;
        private int layoutId;
        private AppWidgetProvider appWidgetProvider;
        private RemoteViews lastRemoteViews;

        public WidgetInfo(View view, int layoutId, AppWidgetProvider appWidgetProvider) {
            this.view = view;
            this.layoutId = layoutId;
            this.appWidgetProvider = appWidgetProvider;
        }
    }
}

