/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.app.Application;
import android.appwidget.AppWidgetManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.res.Resources;
import android.os.IBinder;
import android.os.Looper;
import android.view.LayoutInflater;
import android.widget.Toast;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.internal.RealObject;
import com.xtremelabs.robolectric.res.ResourceLoader;
import com.xtremelabs.robolectric.shadows.ShadowAlertDialog;
import com.xtremelabs.robolectric.shadows.ShadowContextWrapper;
import com.xtremelabs.robolectric.shadows.ShadowDialog;
import com.xtremelabs.robolectric.shadows.ShadowLooper;
import com.xtremelabs.robolectric.shadows.ShadowResources;
import com.xtremelabs.robolectric.tester.org.apache.http.FakeHttpLayer;
import com.xtremelabs.robolectric.util.Scheduler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@Implements(value=Application.class)
public class ShadowApplication
extends ShadowContextWrapper {
    private static final Map<String, String> SYSTEM_SERVICE_MAP = new HashMap<String, String>();
    @RealObject
    private Application realApplication;
    private ResourceLoader resourceLoader;
    private ContentResolver contentResolver;
    private Map<String, Object> systemServices = new HashMap<String, Object>();
    private List<Intent> startedActivities = new ArrayList<Intent>();
    private List<Intent> startedServices = new ArrayList<Intent>();
    private List<Intent> stoppedServies = new ArrayList<Intent>();
    private List<Intent> broadcastIntents = new ArrayList<Intent>();
    private List<ServiceConnection> unboundServiceConnections = new ArrayList<ServiceConnection>();
    private List<Wrapper> registeredReceivers = new ArrayList<Wrapper>();
    private Map<String, Intent> stickyIntents = new HashMap<String, Intent>();
    private FakeHttpLayer fakeHttpLayer = new FakeHttpLayer();
    private Looper mainLooper = ShadowLooper.myLooper();
    private Scheduler backgroundScheduler = new Scheduler();
    private Map<String, Map<String, Object>> sharedPreferenceMap = new HashMap<String, Map<String, Object>>();
    private ArrayList<Toast> shownToasts = new ArrayList();
    private ShadowAlertDialog latestAlertDialog;
    private ShadowDialog latestDialog;
    private Object bluetoothAdapter = Robolectric.newInstanceOf("android.bluetooth.BluetoothAdapter");
    private Resources resources;
    LayoutInflater layoutInflater;
    AppWidgetManager appWidgetManager;
    private ServiceConnection serviceConnection;
    private ComponentName componentNameForBindService;
    private IBinder serviceForBindService;
    private List<String> unbindableActions = new ArrayList<String>();

    public static Application bind(Application application, ResourceLoader resourceLoader) {
        ShadowApplication shadowApplication = Robolectric.shadowOf(application);
        if (shadowApplication.resourceLoader != null) {
            throw new RuntimeException("ResourceLoader already set!");
        }
        shadowApplication.resourceLoader = resourceLoader;
        shadowApplication.resources = ShadowResources.bind(new Resources(null, null, null), resourceLoader);
        return application;
    }

    public List<Toast> getShownToasts() {
        return this.shownToasts;
    }

    public Scheduler getBackgroundScheduler() {
        return this.backgroundScheduler;
    }

    @Override
    @Implementation
    public Context getApplicationContext() {
        return this.realApplication;
    }

    @Override
    @Implementation
    public Resources getResources() {
        if (this.resources == null) {
            this.resources = ShadowResources.bind(new Resources(null, null, null), this.resourceLoader);
        }
        return this.resources;
    }

    @Override
    @Implementation
    public ContentResolver getContentResolver() {
        if (this.contentResolver == null) {
            this.contentResolver = new ContentResolver((Context)this.realApplication){};
        }
        return this.contentResolver;
    }

    @Override
    @Implementation
    public Object getSystemService(String name) {
        String serviceClassName;
        if (name.equals("layout_inflater")) {
            return LayoutInflater.from((Context)this.realApplication);
        }
        Object service = this.systemServices.get(name);
        if (service == null && (serviceClassName = SYSTEM_SERVICE_MAP.get(name)) != null) {
            try {
                service = Robolectric.newInstanceOf(Class.forName(serviceClassName));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            this.systemServices.put(name, service);
        }
        return service;
    }

    @Override
    @Implementation
    public void startActivity(Intent intent) {
        this.startedActivities.add(intent);
    }

    @Override
    @Implementation
    public ComponentName startService(Intent intent) {
        this.startedServices.add(intent);
        return new ComponentName("some.service.package", "SomeServiceName-FIXME");
    }

    @Override
    @Implementation
    public boolean stopService(Intent name) {
        this.stoppedServies.add(name);
        return this.startedServices.contains(name);
    }

    public void setComponentNameAndServiceForBindService(ComponentName name, IBinder service) {
        this.componentNameForBindService = name;
        this.serviceForBindService = service;
    }

    @Override
    @Implementation
    public boolean bindService(Intent intent, final ServiceConnection serviceConnection, int i) {
        if (this.unbindableActions.contains(intent.getAction())) {
            return false;
        }
        this.startedServices.add(intent);
        Robolectric.shadowOf(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                serviceConnection.onServiceConnected(ShadowApplication.this.componentNameForBindService, ShadowApplication.this.serviceForBindService);
            }
        }, 0L);
        return true;
    }

    @Implementation
    public void unbindService(final ServiceConnection serviceConnection) {
        this.unboundServiceConnections.add(serviceConnection);
        Robolectric.shadowOf(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                serviceConnection.onServiceDisconnected(ShadowApplication.this.componentNameForBindService);
            }
        }, 0L);
    }

    public List<ServiceConnection> getUnboundServiceConnections() {
        return this.unboundServiceConnections;
    }

    @Override
    public Intent getNextStartedActivity() {
        if (this.startedActivities.isEmpty()) {
            return null;
        }
        return this.startedActivities.remove(0);
    }

    @Override
    public Intent peekNextStartedActivity() {
        if (this.startedActivities.isEmpty()) {
            return null;
        }
        return this.startedActivities.get(0);
    }

    @Override
    public Intent getNextStartedService() {
        if (this.startedServices.isEmpty()) {
            return null;
        }
        return this.startedServices.remove(0);
    }

    @Override
    public Intent peekNextStartedService() {
        if (this.startedServices.isEmpty()) {
            return null;
        }
        return this.startedServices.get(0);
    }

    @Override
    public void clearStartedServices() {
        this.startedServices.clear();
    }

    @Override
    public Intent getNextStoppedService() {
        if (this.stoppedServies.isEmpty()) {
            return null;
        }
        return this.stoppedServies.remove(0);
    }

    @Override
    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    @Override
    @Implementation
    public void sendBroadcast(Intent intent) {
        this.broadcastIntents.add(intent);
        ArrayList<Wrapper> copy = new ArrayList<Wrapper>();
        copy.addAll(this.registeredReceivers);
        for (Wrapper wrapper : copy) {
            if (!wrapper.intentFilter.matchAction(intent.getAction())) continue;
            wrapper.broadcastReceiver.onReceive((Context)this.realApplication, intent);
        }
    }

    @Override
    public List<Intent> getBroadcastIntents() {
        return this.broadcastIntents;
    }

    @Implementation
    public void sendStickyBroadcast(Intent intent) {
        this.stickyIntents.put(intent.getAction(), intent);
        this.sendBroadcast(intent);
    }

    @Override
    @Implementation
    public Intent registerReceiver(BroadcastReceiver receiver, IntentFilter filter) {
        return this.registerReceiverWithContext(receiver, filter, (Context)this.realApplication);
    }

    Intent registerReceiverWithContext(BroadcastReceiver receiver, IntentFilter filter, Context context) {
        if (receiver != null) {
            this.registeredReceivers.add(new Wrapper(receiver, filter, context));
        }
        return this.getStickyIntent(filter);
    }

    private Intent getStickyIntent(IntentFilter filter) {
        for (Intent stickyIntent : this.stickyIntents.values()) {
            String action = null;
            for (int i = 0; i < filter.countActions(); ++i) {
                action = filter.getAction(i);
                if (!stickyIntent.getAction().equals(action)) continue;
                return stickyIntent;
            }
        }
        return null;
    }

    @Override
    @Implementation
    public void unregisterReceiver(BroadcastReceiver broadcastReceiver) {
        boolean found = false;
        Iterator<Wrapper> iterator = this.registeredReceivers.iterator();
        while (iterator.hasNext()) {
            Wrapper wrapper = iterator.next();
            if (wrapper.broadcastReceiver != broadcastReceiver) continue;
            iterator.remove();
            found = true;
        }
        if (!found) {
            throw new IllegalArgumentException("Receiver not registered: " + broadcastReceiver);
        }
    }

    public void assertNoBroadcastListenersRegistered(Context context, String type) {
        for (Wrapper registeredReceiver : this.registeredReceivers) {
            if (registeredReceiver.context != context) continue;
            IllegalStateException e = new IllegalStateException(type + " " + context + " leaked has leaked IntentReceiver " + registeredReceiver.broadcastReceiver + " that was originally registered here. " + "Are you missing a call to unregisterReceiver()?");
            e.setStackTrace(registeredReceiver.exception.getStackTrace());
            throw e;
        }
    }

    public void assertNoBroadcastListenersOfActionRegistered(Context context, String action) {
        for (Wrapper registeredReceiver : this.registeredReceivers) {
            if (registeredReceiver.context != context) continue;
            Iterator actions = registeredReceiver.intentFilter.actionsIterator();
            while (actions.hasNext()) {
                if (!((String)actions.next()).equals(action)) continue;
                IllegalStateException e = new IllegalStateException("Unexpected BroadcastReceiver on " + context + " with action " + action + " " + registeredReceiver.broadcastReceiver + " that was originally registered here:");
                e.setStackTrace(registeredReceiver.exception.getStackTrace());
                throw e;
            }
        }
    }

    public List<Wrapper> getRegisteredReceivers() {
        return this.registeredReceivers;
    }

    public LayoutInflater getLayoutInflater() {
        return this.layoutInflater;
    }

    public AppWidgetManager getAppWidgetManager() {
        return this.appWidgetManager;
    }

    public FakeHttpLayer getFakeHttpLayer() {
        return this.fakeHttpLayer;
    }

    @Override
    @Implementation
    public Looper getMainLooper() {
        return this.mainLooper;
    }

    public Map<String, Map<String, Object>> getSharedPreferenceMap() {
        return this.sharedPreferenceMap;
    }

    public ShadowAlertDialog getLatestAlertDialog() {
        return this.latestAlertDialog;
    }

    public void setLatestAlertDialog(ShadowAlertDialog latestAlertDialog) {
        this.latestAlertDialog = latestAlertDialog;
    }

    public ShadowDialog getLatestDialog() {
        return this.latestDialog;
    }

    public void setLatestDialog(ShadowDialog latestDialog) {
        this.latestDialog = latestDialog;
    }

    public Object getBluetoothAdapter() {
        return this.bluetoothAdapter;
    }

    public void declareActionUnbindable(String action) {
        this.unbindableActions.add(action);
    }

    public void setSystemService(String key, Object service) {
        this.systemServices.put(key, service);
    }

    static {
        SYSTEM_SERVICE_MAP.put("window", "com.xtremelabs.robolectric.tester.android.view.TestWindowManager");
        SYSTEM_SERVICE_MAP.put("layout_inflater", "android.view.LayoutInflater");
        SYSTEM_SERVICE_MAP.put("activity", "android.app.ActivityManager");
        SYSTEM_SERVICE_MAP.put("power", "android.os.PowerManager");
        SYSTEM_SERVICE_MAP.put("alarm", "android.app.AlarmManager");
        SYSTEM_SERVICE_MAP.put("clipboard", "android.text.ClipboardManager");
        SYSTEM_SERVICE_MAP.put("notification", "android.app.NotificationManager");
        SYSTEM_SERVICE_MAP.put("keyguard", "android.app.KeyguardManager");
        SYSTEM_SERVICE_MAP.put("location", "android.location.LocationManager");
        SYSTEM_SERVICE_MAP.put("search", "android.app.SearchManager");
        SYSTEM_SERVICE_MAP.put("sensor", "android.hardware.SensorManager");
        SYSTEM_SERVICE_MAP.put("storage", "android.os.storage.StorageManager");
        SYSTEM_SERVICE_MAP.put("vibrator", "android.os.Vibrator");
        SYSTEM_SERVICE_MAP.put("connectivity", "android.net.ConnectivityManager");
        SYSTEM_SERVICE_MAP.put("wifi", "android.net.wifi.WifiManager");
        SYSTEM_SERVICE_MAP.put("audio", "android.media.AudioManager");
        SYSTEM_SERVICE_MAP.put("phone", "android.telephony.TelephonyManager");
        SYSTEM_SERVICE_MAP.put("input_method", "android.view.inputmethod.InputMethodManager");
        SYSTEM_SERVICE_MAP.put("uimode", "android.app.UiModeManager");
        SYSTEM_SERVICE_MAP.put("download", "android.app.DownloadManager");
    }

    public class Wrapper {
        public BroadcastReceiver broadcastReceiver;
        public IntentFilter intentFilter;
        public Context context;
        public Throwable exception;

        public Wrapper(BroadcastReceiver broadcastReceiver, IntentFilter intentFilter, Context context) {
            this.broadcastReceiver = broadcastReceiver;
            this.intentFilter = intentFilter;
            this.context = context;
            this.exception = new Throwable();
        }

        public BroadcastReceiver getBroadcastReceiver() {
            return this.broadcastReceiver;
        }

        public IntentFilter getIntentFilter() {
            return this.intentFilter;
        }

        public Context getContext() {
            return this.context;
        }
    }
}

